/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc_2_building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc_2_building_halide_with_c_make.html#installing-cmake", [
        [ "Cross-platform", "md_doc_2_building_halide_with_c_make.html#cross-platform", null ],
        [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows", null ],
        [ "macOS", "md_doc_2_building_halide_with_c_make.html#macos", null ],
        [ "Ubuntu Linux", "md_doc_2_building_halide_with_c_make.html#ubuntu-linux", null ],
        [ "Optional: Install Ninja", "md_doc_2_building_halide_with_c_make.html#optional-install-ninja", null ]
      ] ],
      [ "Dependencies", "md_doc_2_building_halide_with_c_make.html#dependencies", [
        [ "Summary", "md_doc_2_building_halide_with_c_make.html#summary", null ],
        [ "Installing dependencies", "md_doc_2_building_halide_with_c_make.html#installing-dependencies", [
          [ "vcpkg", "md_doc_2_building_halide_with_c_make.html#vcpkg", null ],
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-1", null ],
          [ "Homebrew", "md_doc_2_building_halide_with_c_make.html#homebrew", null ],
          [ "Ubuntu / Debian", "md_doc_2_building_halide_with_c_make.html#ubuntu--debian", null ],
          [ "Python", "md_doc_2_building_halide_with_c_make.html#python", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc_2_building_halide_with_c_make.html#building-halide", [
        [ "Basic build", "md_doc_2_building_halide_with_c_make.html#basic-build", [
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-2", null ],
          [ "macOS and Linux", "md_doc_2_building_halide_with_c_make.html#macos-and-linux", null ]
        ] ],
        [ "CMake Presets", "md_doc_2_building_halide_with_c_make.html#cmake-presets", [
          [ "Common presets", "md_doc_2_building_halide_with_c_make.html#common-presets", null ],
          [ "Vcpkg presets", "md_doc_2_building_halide_with_c_make.html#vcpkg-presets", null ],
          [ "Sanitizer presets", "md_doc_2_building_halide_with_c_make.html#sanitizer-presets", null ]
        ] ],
        [ "Build options", "md_doc_2_building_halide_with_c_make.html#build-options", null ],
        [ "Installing", "md_doc_2_building_halide_with_c_make.html#installing", null ]
      ] ],
      [ "Building Halide with pip", "md_doc_2_building_halide_with_c_make.html#building-halide-with-pip", [
        [ "Using ccache with pip builds", "md_doc_2_building_halide_with_c_make.html#using-ccache-with-pip-builds", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc_2_code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc_2_code_style_c_make.html#general-guidelines-and-best-practices", [
        [ "Prohibited commands list", "md_doc_2_code_style_c_make.html#prohibited-commands-list", null ],
        [ "Prohibited variables list", "md_doc_2_code_style_c_make.html#prohibited-variables-list", null ]
      ] ],
      [ "Adding tests", "md_doc_2_code_style_c_make.html#adding-tests", null ],
      [ "Adding apps", "md_doc_2_code_style_c_make.html#adding-apps", null ]
    ] ],
    [ "Fuzz testing", "md_doc_2_fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc_2_fuzz_testing.html#building-fuzz-tests", null ],
      [ "Using the fuzz-harnesses", "md_doc_2_fuzz_testing.html#using-the-fuzz-harnesses", null ],
      [ "Reproducing crashes", "md_doc_2_fuzz_testing.html#reproducing-crashes", null ],
      [ "Adding new fuzz tests", "md_doc_2_fuzz_testing.html#adding-new-fuzz-tests", null ],
      [ "Other useful materials", "md_doc_2_fuzz_testing.html#other-useful-materials", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc_2_halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc_2_halide_c_make_package.html#a-basic-cmake-project", [
        [ "JIT mode", "md_doc_2_halide_c_make_package.html#jit-mode", null ],
        [ "AOT mode", "md_doc_2_halide_c_make_package.html#aot-mode", [
          [ "Autoschedulers", "md_doc_2_halide_c_make_package.html#autoschedulers", null ],
          [ "RunGenMain", "md_doc_2_halide_c_make_package.html#rungenmain", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc_2_halide_c_make_package.html#halide-package-documentation", [
        [ "Components", "md_doc_2_halide_c_make_package.html#components", null ],
        [ "Variables", "md_doc_2_halide_c_make_package.html#variables", null ],
        [ "Imported targets", "md_doc_2_halide_c_make_package.html#imported-targets", null ],
        [ "Functions", "md_doc_2_halide_c_make_package.html#functions", [
          [ "<tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#add_halide_generator", null ],
          [ "<tt>add_halide_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_library", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_python_extension_library", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc_2_halide_c_make_package.html#add_halide_runtime", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc_2_halide_c_make_package.html#cross-compiling", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#use-add_halide_generator", null ],
        [ "Use a super-build", "md_doc_2_halide_c_make_package.html#use-a-super-build", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc_2_halide_c_make_package.html#use-externalproject-directly", null ],
        [ "Use an emulator or run on device", "md_doc_2_halide_c_make_package.html#use-an-emulator-or-run-on-device", null ],
        [ "Bypass CMake", "md_doc_2_halide_c_make_package.html#bypass-cmake", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc_2_hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc_2_hexagon.html#autotoc_md1-obtain-and-build-trunk-llvm-and-clang", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc_2_hexagon.html#autotoc_md2-download-and-install-the-hexagon-sdk-and-hexagon-tools", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc_2_hexagon.html#autotoc_md3-build-and-run-an-example-for-hexagon-hvx", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc_2_hexagon.html#to-build-and-run-the-blur-example-in-halideappsblur-on-android", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc_2_python.html", [
      [ "Acquiring the Python bindings", "md_doc_2_python.html#acquiring-the-python-bindings", null ],
      [ "Building the Python bindings", "md_doc_2_python.html#building-the-python-bindings", [
        [ "Using CMake directly", "md_doc_2_python.html#using-cmake-directly", null ],
        [ "Using wheel infrastructure", "md_doc_2_python.html#using-wheel-infrastructure", null ]
      ] ],
      [ "Documentation and Examples", "md_doc_2_python.html#documentation-and-examples", null ],
      [ "Differences from C++ API", "md_doc_2_python.html#differences-from-c-api", null ],
      [ "Example of Simple Usage", "md_doc_2_python.html#example-of-simple-usage", null ],
      [ "Halide Generators In Python", "md_doc_2_python.html#halide-generators-in-python", [
        [ "Writing a Generator in Python", "md_doc_2_python.html#writing-a-generator-in-python", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc_2_python.html#hlgeneratorname", null ],
          [ "hl.GeneratorParam", "md_doc_2_python.html#hlgeneratorparam", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc_2_python.html#hlinputbuffer-hlinputscalar", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc_2_python.html#hloutputbuffer-hloutputscalar", null ],
          [ "Names", "md_doc_2_python.html#names", null ],
          [ "generate() method", "md_doc_2_python.html#generate-method", null ],
          [ "Types for Inputs and Outputs", "md_doc_2_python.html#types-for-inputs-and-outputs", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc_2_python.html#using-a-generator-for-jit-compilation", null ],
        [ "Using a Generator for AOT compilation", "md_doc_2_python.html#using-a-generator-for-aot-compilation", null ],
        [ "Calling Generator-Produced code from Python", "md_doc_2_python.html#calling-generator-produced-code-from-python", null ],
        [ "Advanced Generator-Related Topics", "md_doc_2_python.html#advanced-generator-related-topics", [
          [ "Generator Aliases", "md_doc_2_python.html#generator-aliases", null ],
          [ "Dynamic Inputs and Outputs", "md_doc_2_python.html#dynamic-inputs-and-outputs", null ],
          [ "Calling a Generator Directly", "md_doc_2_python.html#calling-a-generator-directly", null ],
          [ "The Lifecycle Of A Generator", "md_doc_2_python.html#the-lifecycle-of-a-generator", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc_2_python.html#notable-differences-between-c-and-python-generators", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc_2_python.html#keeping-up-to-date", null ],
      [ "License", "md_doc_2_python.html#license", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc_2_run_gen.html", [
      [ "Overview", "md_doc_2_run_gen.html#overview", null ],
      [ "Benchmarking", "md_doc_2_run_gen.html#benchmarking", null ],
      [ "Measuring Memory Usage", "md_doc_2_run_gen.html#measuring-memory-usage", null ],
      [ "Using RunGen in Make", "md_doc_2_run_gen.html#using-rungen-in-make", null ],
      [ "Known Issues & Caveats", "md_doc_2_run_gen.html#known-issues--caveats", null ]
    ] ],
    [ "Testing", "md_doc_2_testing.html", [
      [ "Organization", "md_doc_2_testing.html#organization", null ],
      [ "Debugging with LLDB", "md_doc_2_testing.html#debugging-with-lldb", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc_2_vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc_2_vulkan.html#compiling-halide-wvulkan-support", null ],
      [ "Vulkan Runtime Environment:", "md_doc_2_vulkan.html#vulkan-runtime-environment", [
        [ "Windows", "md_doc_2_vulkan.html#windows-3", null ],
        [ "Linux", "md_doc_2_vulkan.html#linux", null ],
        [ "Mac", "md_doc_2_vulkan.html#mac", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc_2_vulkan.html#testing-your-vulkan-environment", null ],
      [ "Targetting Vulkan", "md_doc_2_vulkan.html#targetting-vulkan", null ],
      [ "Useful Runtime Environment Variables", "md_doc_2_vulkan.html#useful-runtime-environment-variables", null ],
      [ "Debug Environment Variables", "md_doc_2_vulkan.html#debug-environment-variables", null ],
      [ "Current Status", "md_doc_2_vulkan.html#current-status", null ],
      [ "Caveats:", "md_doc_2_vulkan.html#caveats", null ],
      [ "Known TODO:", "md_doc_2_vulkan.html#known-todo", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc_2_web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc_2_web_assembly.html#additional-tooling-requirements", null ],
      [ "AOT Limitations", "md_doc_2_web_assembly.html#aot-limitations", null ],
      [ "JIT Limitations", "md_doc_2_web_assembly.html#jit-limitations", [
        [ "Using V8 as the interpreter", "md_doc_2_web_assembly.html#using-v8-as-the-interpreter", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc_2_web_assembly.html#to-use-halide-for-webassembly", [
        [ "Enabling wasm JIT", "md_doc_2_web_assembly.html#enabling-wasm-jit", null ],
        [ "Enabling wasm AOT", "md_doc_2_web_assembly.html#enabling-wasm-aot", null ]
      ] ],
      [ "Running benchmarks", "md_doc_2_web_assembly.html#running-benchmarks", null ],
      [ "Using Threads", "md_doc_2_web_assembly.html#using-threads", null ],
      [ "Known Limitations And Caveats", "md_doc_2_web_assembly.html#known-limitations-and-caveats", null ],
      [ "Known TODO:", "md_doc_2_web_assembly.html#known-todo-1", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc_2_web_g_p_u.html", [
      [ "Known limitations", "md_doc_2_web_g_p_u.html#known-limitations", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-with-webassembly-via-emscripten-hl_targetwasm-32-wasmrt-webgpu", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-natively-hl_targethost-webgpu", null ],
      [ "Setting up Dawn", "md_doc_2_web_g_p_u.html#setting-up-dawn", null ],
      [ "Updating mini_webgpu.h", "md_doc_2_web_g_p_u.html#updating-mini_webgpuh", null ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Symbols", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#a8e2154ce76c37412e7d74c0c7fe5fecb",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2ae8b4b40ec3622e371789b790caabc083",
"_halide_runtime_8h.html",
"_halide_runtime_8h.html#ab199bb9f42e5a36069af2e8b08994eef",
"_hexagon_optimize_8h.html#ad61e99863aa9fd2833e535440b632093",
"_i_r_operator_8h.html#a09688fdcdef640b559405579e0048ded",
"_i_r_operator_8h.html#af9105ae9f0995f450825e522170f5d1e",
"_object_instance_registry_8h.html",
"_type_8h.html#a1921c164d599215c142b849092728f58",
"android__ioctl_8h.html#afb20e2f91557abf9104192c2d3896815",
"class_halide_1_1_default_cost_model.html#a842c7b068634e5f3cee34dcabc52ce42",
"class_halide_1_1_func.html#aa17f5091968639d630d29f640aff21dd",
"class_halide_1_1_generator_context.html#ad725d02ec831b39a4b63174bece205de",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a9295d0cdb548a8932058768f1d60ee3c",
"class_halide_1_1_internal_1_1_closure.html#ab9f584b5e5ba025878bc8b7987e4df69",
"class_halide_1_1_internal_1_1_code_gen___c.html#aa80d583912c4f167f6a520d4bc922143",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aaf31ae3fe2a9a22d2afa93583ad4ac07",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a62772a48a5b8bb039db2920b6d8fb7b2",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ae2b81caf2b65dcf5e522503c1f4af37e",
"class_halide_1_1_internal_1_1_code_gen___posix.html#af0e1a3b165a5d84e2482a6bde1a21f76",
"class_halide_1_1_internal_1_1_elf_1_1_relocation.html#a0061bb5c115b9a4e1adbb1bee8ca771d",
"class_halide_1_1_internal_1_1_func_schedule.html#a0bf19917d7f275dfa9b453dce45bf344",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a8653eef4cf7dd4fd556e269751b03908",
"class_halide_1_1_internal_1_1_generator_input___arithmetic.html#a077420a8f6eaff05fb01875354996ef7",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a8d181f5a1408085b4d556883de5cd344",
"class_halide_1_1_internal_1_1_generator_param_base.html#a7eaf666933890a88ccde8ad9a1d078e1",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a7bed52b9fe426612b7470d27fd897b99",
"class_halide_1_1_internal_1_1_i_r_visitor.html",
"class_halide_1_1_internal_1_1_scope.html#a1171c247a83f0022c003d2bf1e01972e",
"class_halide_1_1_internal_1_1_small_stack_3_01void_01_4.html#a2a3c0a4ba0404cde4a7c6e74886a9349",
"class_halide_1_1_module.html#af47fcf2cef7bc6c6c951fa70521fe6fe",
"class_halide_1_1_parameter.html#ac9d912036e9e41ccd70550e2d538bf50",
"class_halide_1_1_runtime_1_1_buffer.html#a29684a67bb84956fc25fc028c436e951",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a70e7ebdfd1ee276af03dcacd1de249ee",
"class_halide_1_1_runtime_1_1_internal_1_1_printer_base.html#a2e9bff2e839e138464a58e3c4457ee78",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#aac071a3f99aa3e9f92435f705be70b02",
"classcmdline_1_1parser.html#a0829039262c93910a9fee8c80f3edb64",
"functions_vars_u.html",
"md_doc_2_halide_c_make_package.html#add_halide_python_extension_library",
"mini__cl_8h.html#a3fd815a4421e3f7f26ee2f1c388da8c7",
"mini__cl_8h.html#accc650acf63c159fd70b97ad10b31138",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaae8aeac2820ce2047cbd66eab11fb83ca",
"mini__d3d12_8h.html#a4a10292c6cc8e44353d32c41affa4d4b",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcae81b5fe2b6603ce2babd2795986d2f6b",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335daa2f641423a22ca9e1c1498ff59e4a72d",
"mini__d3d12_8h.html#ae02d25fc8f1a0c2067548bc16b8381b3",
"mini__hexagon__dma_8h.html#abb399ea6a6109d6f135c57a03a5be323",
"mini__webgpu_8h.html#a17fa73723f362f7ced23580a36589760",
"mini__webgpu_8h.html#a57a04e266142c3e6f3fd131481b2ec3fa0d49e10ea53484c989a8ed5aa750272d",
"mini__webgpu_8h.html#a825c3d04e08b66e43cda3bdce9e77092",
"mini__webgpu_8h.html#ad29983547909bf5e9875d82212af882fac0a93abf306850d87b5022b612925d4e",
"namespace_halide.html#a2ce048ac6f7c309d26c83fbc3132be2b",
"namespace_halide.html#ab8dc474abd04c4f1b8dd2dcb4d2442e3",
"namespace_halide_1_1_internal.html#a239019adaa0b7ed8fb0c6c81a6f694d3",
"namespace_halide_1_1_internal.html#a88cbc086e9926046bdb9f4ade681111a",
"namespace_halide_1_1_internal.html#aee9e0b8e5376e2294d74ded8e7de9ef2a36c81967df3424f919e89b09ed34c90d",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a7d7a0be176f231cfdf8c62021bbda629",
"namespace_halide_1_1_runtime_1_1_internal_1_1_cuda.html#a2f191c22706ed27f2c64f0e1ab3d4ab9a546765bbee90cb10673cdcd9b886b44c",
"namespacemembers_func_m.html",
"struct_d3_d12___c_l_e_a_r___v_a_l_u_e.html",
"struct_d3_d12___r_o_o_t___s_i_g_n_a_t_u_r_e___d_e_s_c1.html",
"struct_halide_1_1_argument.html#a19465e45c44f1ba93484662d09706107",
"struct_halide_1_1_internal_1_1_abstract_generator_1_1_arg_info.html#a8ade485b773fc2c7da6610c36fc84d4f",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#ac2bec52f6010681af34cc4ca86295aad",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#aeb068bb4e663ac9346944443bef40a41",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#ac2409ae36da8ad0bdda29923e879886c",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_optional_rational.html#a1c349c4c9de3bfd076db1550e96006f4",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a88bf5e237b76ea441d12703ee2560dc3",
"struct_halide_1_1_internal_1_1_box.html#a4d47b4be34d44545b224591ca716f0f9",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974aecc18b09944a0c1c61d037f10dd7fdbf",
"struct_halide_1_1_internal_1_1_device_argument.html",
"struct_halide_1_1_internal_1_1_i_r_graph_deep_compare.html#aca8de8cb5feb9232ff3d9b57c658d712",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_negate_op.html#ade3fcdde5b78cb5332ee734f9b2a39f4",
"struct_halide_1_1_internal_1_1_indentation.html#a1b9adb9f92b1d1dec988857daa50a1d1",
"struct_halide_1_1_internal_1_1_lowered_func.html#aeac32842105eb81a711171592174faf6",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dadc33066c3993e0d50896e533fd692ce0",
"struct_halide_1_1_internal_1_1_reduction_variable.html#a4562bcb8f14e1939076a2806dc6c0915",
"struct_halide_1_1_internal_1_1_schedule_features.html#af55909b02a1fc829b2b23f300c5676d8",
"struct_halide_1_1_internal_1_1_storage_dim.html#a0157f5cf508314a37bfc48485e4cb9bc",
"struct_halide_1_1_py_torch_1_1_user_context.html",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_arena_1_1_config.html#a4c71c995466021497d9ca5cbe9107fda",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_dispatch_data.html#a38cb99b55c892d0a574095a8b8c32bb1",
"struct_halide_1_1_target.html#a8eaefa280388ad4813a83fd60a2702b1",
"struct_halide_1_1_target.html#af17585cfd5ec92952fd361117d89d4b1ae6d33003db3020c4c578c645239f2973",
"struct_i_d3_d12_command_queue_vtbl.html#a624c3bfa50e99d79b203378e57b78171",
"struct_i_d3_d12_graphics_command_list_vtbl.html#a42bc327f185a6e0a778e1550576c0b5b",
"struct_i_d_x_g_i_adapter_vtbl.html#a72feaab1a0576d0a718cab977a52ad70",
"struct_w_g_p_u_dawn_compute_pipeline_full_subgroups.html#a4316bec36cdf5566d79cb64bd0a1b3d4",
"struct_w_g_p_u_render_pass_descriptor_max_draw_count.html#aebb7b4267cca6fd2648f3f1f2a7cbd48",
"struct_w_g_p_u_texture_descriptor.html#a5894057d0a6f44440aa8055cf025dcbf",
"structst_dma_wrapper___dma_transfer_setup.html#ab0dcb052fb8774036eae8c7f10df4b95"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';