/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc__building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc__building_halide_with_c_make.html#autotoc_md1", [
        [ "Cross-platform", "md_doc__building_halide_with_c_make.html#autotoc_md2", null ],
        [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md3", null ],
        [ "macOS", "md_doc__building_halide_with_c_make.html#autotoc_md4", null ],
        [ "Ubuntu Linux", "md_doc__building_halide_with_c_make.html#autotoc_md5", null ],
        [ "Optional: Install Ninja", "md_doc__building_halide_with_c_make.html#autotoc_md6", null ]
      ] ],
      [ "Dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md7", [
        [ "Summary", "md_doc__building_halide_with_c_make.html#autotoc_md8", null ],
        [ "Installing dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md9", [
          [ "vcpkg", "md_doc__building_halide_with_c_make.html#autotoc_md10", null ],
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md11", null ],
          [ "Homebrew", "md_doc__building_halide_with_c_make.html#autotoc_md12", null ],
          [ "Ubuntu / Debian", "md_doc__building_halide_with_c_make.html#autotoc_md13", null ],
          [ "Python", "md_doc__building_halide_with_c_make.html#autotoc_md14", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc__building_halide_with_c_make.html#autotoc_md15", [
        [ "Basic build", "md_doc__building_halide_with_c_make.html#autotoc_md16", [
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md17", null ],
          [ "macOS and Linux", "md_doc__building_halide_with_c_make.html#autotoc_md18", null ]
        ] ],
        [ "CMake Presets", "md_doc__building_halide_with_c_make.html#autotoc_md19", [
          [ "Common presets", "md_doc__building_halide_with_c_make.html#autotoc_md20", null ],
          [ "Vcpkg presets", "md_doc__building_halide_with_c_make.html#autotoc_md21", null ],
          [ "Sanitizer presets", "md_doc__building_halide_with_c_make.html#autotoc_md22", null ]
        ] ],
        [ "Build options", "md_doc__building_halide_with_c_make.html#autotoc_md23", null ],
        [ "Installing", "md_doc__building_halide_with_c_make.html#autotoc_md24", null ]
      ] ],
      [ "Building Halide with pip", "md_doc__building_halide_with_c_make.html#autotoc_md25", [
        [ "Using ccache with pip builds", "md_doc__building_halide_with_c_make.html#autotoc_md26", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc__code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc__code_style_c_make.html#autotoc_md28", [
        [ "Prohibited commands list", "md_doc__code_style_c_make.html#autotoc_md29", null ],
        [ "Prohibited variables list", "md_doc__code_style_c_make.html#autotoc_md30", null ]
      ] ],
      [ "Adding tests", "md_doc__code_style_c_make.html#autotoc_md31", null ],
      [ "Adding apps", "md_doc__code_style_c_make.html#autotoc_md32", null ]
    ] ],
    [ "Fuzz testing", "md_doc__fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc__fuzz_testing.html#autotoc_md34", null ],
      [ "Using the fuzz-harnesses", "md_doc__fuzz_testing.html#autotoc_md35", null ],
      [ "Reproducing crashes", "md_doc__fuzz_testing.html#autotoc_md36", null ],
      [ "Adding new fuzz tests", "md_doc__fuzz_testing.html#autotoc_md37", null ],
      [ "Other useful materials", "md_doc__fuzz_testing.html#autotoc_md38", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc__halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc__halide_c_make_package.html#autotoc_md40", [
        [ "JIT mode", "md_doc__halide_c_make_package.html#autotoc_md41", null ],
        [ "AOT mode", "md_doc__halide_c_make_package.html#autotoc_md42", [
          [ "Autoschedulers", "md_doc__halide_c_make_package.html#autotoc_md43", null ],
          [ "RunGenMain", "md_doc__halide_c_make_package.html#autotoc_md44", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc__halide_c_make_package.html#autotoc_md45", [
        [ "Components", "md_doc__halide_c_make_package.html#autotoc_md46", null ],
        [ "Variables", "md_doc__halide_c_make_package.html#autotoc_md47", null ],
        [ "Imported targets", "md_doc__halide_c_make_package.html#autotoc_md48", null ],
        [ "Functions", "md_doc__halide_c_make_package.html#autotoc_md49", [
          [ "<tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md50", null ],
          [ "<tt>add_halide_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md51", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md52", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc__halide_c_make_package.html#autotoc_md53", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc__halide_c_make_package.html#autotoc_md54", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md55", null ],
        [ "Use a super-build", "md_doc__halide_c_make_package.html#autotoc_md56", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc__halide_c_make_package.html#autotoc_md57", null ],
        [ "Use an emulator or run on device", "md_doc__halide_c_make_package.html#autotoc_md58", null ],
        [ "Bypass CMake", "md_doc__halide_c_make_package.html#autotoc_md59", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc__hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc__hexagon.html#autotoc_md61", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc__hexagon.html#autotoc_md62", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc__hexagon.html#autotoc_md63", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc__hexagon.html#autotoc_md64", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc__python.html", [
      [ "Acquiring the Python bindings", "md_doc__python.html#autotoc_md66", null ],
      [ "Building the Python bindings", "md_doc__python.html#autotoc_md67", [
        [ "Using CMake directly", "md_doc__python.html#autotoc_md68", null ],
        [ "Using wheel infrastructure", "md_doc__python.html#autotoc_md69", null ]
      ] ],
      [ "Documentation and Examples", "md_doc__python.html#autotoc_md70", null ],
      [ "Differences from C++ API", "md_doc__python.html#autotoc_md71", null ],
      [ "Example of Simple Usage", "md_doc__python.html#autotoc_md72", null ],
      [ "Halide Generators In Python", "md_doc__python.html#autotoc_md73", [
        [ "Writing a Generator in Python", "md_doc__python.html#autotoc_md74", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc__python.html#autotoc_md75", null ],
          [ "hl.GeneratorParam", "md_doc__python.html#autotoc_md76", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc__python.html#autotoc_md77", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc__python.html#autotoc_md78", null ],
          [ "Names", "md_doc__python.html#autotoc_md79", null ],
          [ "generate() method", "md_doc__python.html#autotoc_md80", null ],
          [ "Types for Inputs and Outputs", "md_doc__python.html#autotoc_md81", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc__python.html#autotoc_md82", null ],
        [ "Using a Generator for AOT compilation", "md_doc__python.html#autotoc_md83", null ],
        [ "Calling Generator-Produced code from Python", "md_doc__python.html#autotoc_md84", null ],
        [ "Advanced Generator-Related Topics", "md_doc__python.html#autotoc_md85", [
          [ "Generator Aliases", "md_doc__python.html#autotoc_md86", null ],
          [ "Dynamic Inputs and Outputs", "md_doc__python.html#autotoc_md87", null ],
          [ "Calling a Generator Directly", "md_doc__python.html#autotoc_md88", null ],
          [ "The Lifecycle Of A Generator", "md_doc__python.html#autotoc_md89", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc__python.html#autotoc_md90", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc__python.html#autotoc_md91", null ],
      [ "License", "md_doc__python.html#autotoc_md92", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc__run_gen.html", [
      [ "Overview", "md_doc__run_gen.html#autotoc_md94", null ],
      [ "Benchmarking", "md_doc__run_gen.html#autotoc_md95", null ],
      [ "Measuring Memory Usage", "md_doc__run_gen.html#autotoc_md96", null ],
      [ "Using RunGen in Make", "md_doc__run_gen.html#autotoc_md97", null ],
      [ "Known Issues & Caveats", "md_doc__run_gen.html#autotoc_md98", null ]
    ] ],
    [ "Testing", "md_doc__testing.html", [
      [ "Organization", "md_doc__testing.html#autotoc_md100", null ],
      [ "Debugging with LLDB", "md_doc__testing.html#autotoc_md101", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc__vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc__vulkan.html#autotoc_md103", null ],
      [ "Vulkan Runtime Environment:", "md_doc__vulkan.html#autotoc_md104", [
        [ "Windows", "md_doc__vulkan.html#autotoc_md105", null ],
        [ "Linux", "md_doc__vulkan.html#autotoc_md106", null ],
        [ "Mac", "md_doc__vulkan.html#autotoc_md107", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc__vulkan.html#autotoc_md108", null ],
      [ "Targetting Vulkan", "md_doc__vulkan.html#autotoc_md109", null ],
      [ "Useful Runtime Environment Variables", "md_doc__vulkan.html#autotoc_md110", null ],
      [ "Debug Environment Variables", "md_doc__vulkan.html#autotoc_md111", null ],
      [ "Current Status", "md_doc__vulkan.html#autotoc_md112", null ],
      [ "Caveats:", "md_doc__vulkan.html#autotoc_md113", null ],
      [ "Known TODO:", "md_doc__vulkan.html#autotoc_md114", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc__web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc__web_assembly.html#autotoc_md116", null ],
      [ "AOT Limitations", "md_doc__web_assembly.html#autotoc_md117", null ],
      [ "JIT Limitations", "md_doc__web_assembly.html#autotoc_md118", [
        [ "Using V8 as the interpreter", "md_doc__web_assembly.html#autotoc_md119", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc__web_assembly.html#autotoc_md120", [
        [ "Enabling wasm JIT", "md_doc__web_assembly.html#autotoc_md121", null ],
        [ "Enabling wasm AOT", "md_doc__web_assembly.html#autotoc_md122", null ]
      ] ],
      [ "Running benchmarks", "md_doc__web_assembly.html#autotoc_md123", null ],
      [ "Using Threads", "md_doc__web_assembly.html#autotoc_md124", null ],
      [ "Known Limitations And Caveats", "md_doc__web_assembly.html#autotoc_md125", null ],
      [ "Known TODO:", "md_doc__web_assembly.html#autotoc_md126", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc__web_g_p_u.html", [
      [ "Known limitations", "md_doc__web_g_p_u.html#autotoc_md128", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md129", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md130", null ],
      [ "Setting up Dawn", "md_doc__web_g_p_u.html#autotoc_md131", null ],
      [ "Updating mini_webgpu.h", "md_doc__web_g_p_u.html#autotoc_md132", null ]
    ] ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#a8e2154ce76c37412e7d74c0c7fe5fecb",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2ae8b4b40ec3622e371789b790caabc083",
"_halide_runtime_8h.html",
"_halide_runtime_8h.html#ab199bb9f42e5a36069af2e8b08994eef",
"_hexagon_optimize_8h.html#ad61e99863aa9fd2833e535440b632093",
"_i_r_operator_8h.html#a082d3bda0d60128ae127d0879e7e38c9",
"_i_r_operator_8h.html#af7df709582bdb9d7844efa9cd6b69625",
"_monotonic_8h.html#af6de4b237eafb498206aa2eb0c94b4ad",
"_type_8h.html#a11df91175e8ac20ce33379c178e8c7bc",
"android__ioctl_8h.html#af5f6bb51c68947a6919b2f017f754c80",
"class_halide_1_1_default_cost_model.html#a7e1e8276960aefbacf55c13990372195",
"class_halide_1_1_func.html#a9f8a7b45374c9820810ef6a4a9d6740c",
"class_halide_1_1_generator_context.html#a91fad3bd9fbf917d323a8648ab8f937c",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a6f090b1248e2ef6ad51588f4235f798d",
"class_halide_1_1_internal_1_1_closure.html#ab593b7520a930bd0f45ff9557309f7c4",
"class_halide_1_1_internal_1_1_code_gen___c.html#aa2a0647e17ceb7a5483257016b2f7f93",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aaae3a742d1f551c74370d883d1e00f79",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a5e487141d83fda347874c102904bc2d7",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#adfea81a166f2b255147c00cd754de519",
"class_halide_1_1_internal_1_1_code_gen___posix.html#ae34c68b59491d5f0d8f0da070981df26",
"class_halide_1_1_internal_1_1_elf_1_1_object.html#aedad9b4c01137ea5cd8e10e071900233",
"class_halide_1_1_internal_1_1_find_all_calls.html",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a6d3aa9ef773d8dd3d4708108decb39e0",
"class_halide_1_1_internal_1_1_generator_factory_provider.html#ac3fa1267db2e4cca2ee60238444adf92",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a3ac495c1dd31bd00aa4efafe321e9172",
"class_halide_1_1_internal_1_1_generator_param_base.html#a585e9c1a5def9bb5cf391ccda588597f",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a5c64fd5a7b9d746d9e7d53d90def752b",
"class_halide_1_1_internal_1_1_i_r_printer.html#ae839038cc3d1e261ffeada2a9bf19337",
"class_halide_1_1_internal_1_1_report_base.html#ae204c03c11ba6c07e3bf8f451a76f432",
"class_halide_1_1_internal_1_1_small_stack.html#aa70b51ebefd5c504d2c6a7dca321065f",
"class_halide_1_1_module.html#ac3b8371e01ae67f99baeb4742c803eb4",
"class_halide_1_1_parameter.html#ab3fa8caa1a535eb2c05980e9e0eb835f",
"class_halide_1_1_runtime_1_1_buffer.html#a181ca03d2303b7573498ab8e9ecec429",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a3210af39d7cd01dc860b10d86b8d7804",
"class_halide_1_1_runtime_1_1_internal_1_1_pointer_table.html#af9eba3487dad65b1f00d73a628880ea9",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#a711b9c52e27ae872de924fe30938a33e",
"classcmdline_1_1detail_1_1lexical__cast__t.html",
"functions_vars_g.html",
"md_doc__code_style_c_make.html#autotoc_md28",
"mini__cl_8h.html#a3a2c10b0d0dfddda935e876e6aae9f79",
"mini__cl_8h.html#ac519ab26c257eac9852136e50530b85c",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaab7cfb6878a26e71d546f79b2e694817c",
"mini__d3d12_8h.html#a467be480cbe97bff46cfb0a6f728c708",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcad5f8f292392e1f9012ade156162ee60f",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335da2639dcd780f5c08b608506cb9c20833d",
"mini__d3d12_8h.html#ad89d726f42e6e53f157e0ddfcf4e0c76a73d019a09fd77cd8fb34eb2f34fccc00",
"mini__hexagon__dma_8h.html#a517a4b46a7468ed607c2aa282bd6d8b9",
"mini__webgpu_8h.html#a0f20513eb24158a4d0901f2c4b610f34af6b3fac82cac254993e8f755e4d0ec6b",
"mini__webgpu_8h.html#a5088e64005123d0440b68457c5e49245",
"mini__webgpu_8h.html#a7fa2c2627783fe742a84ebb6c3618726a44699c14fd8b2ab9eb2e5bbb533a5b80",
"mini__webgpu_8h.html#acc5a7c26f6dccd8f5b22a520090520d9ad72c6886baff0b7c2630b70d13b0af64",
"namespace_halide.html#a1f99adc84a7324351d6037eacb3f9157",
"namespace_halide.html#aab45b50a1d7838663e5cfaceff50d8b7",
"namespace_halide_1_1_internal.html#a1b0244f4d3e877af92bb3326b5ba74d2",
"namespace_halide_1_1_internal.html#a81e21c111cd68481735b95e47fc3db9c",
"namespace_halide_1_1_internal.html#ae8e925c5d658d689e0798106019bc083",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a61d735cfe38f06bbe697e03892f83630",
"namespace_halide_1_1_runtime_1_1_internal_1_1_constants.html",
"namespacemembers.html",
"struct_d3_d12___b_o_x.html#a7da8437f8929cc6b4507b4c3da861202",
"struct_d3_d12___r_o_o_t___d_e_s_c_r_i_p_t_o_r___t_a_b_l_e1.html",
"struct_d_x_g_i___a_d_a_p_t_e_r___d_e_s_c1.html",
"struct_halide_1_1_fuse_loop_level.html#a3b36f19453ac12724a7ad2c9dce03eec",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#a6b8c688cd8a865ede664e2911e2bddc6",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#a58b81df9cdf1eb8a1651f158e418d6eb",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#aa3ce33be4ac6505cf3cf84a1905f67cc",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_mem_traits_3_01_local_mem_01_4.html#aacfbf14da20511e6e97d15beadc0ad3c",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a6708d4a4d98f8f848856fd15b3381d3b",
"struct_halide_1_1_internal_1_1_bound.html#a16a52e9c3e40194f4112a690f24be4a4",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974acfaeb86ddcface67f0ddd4d4e9ffa483",
"struct_halide_1_1_internal_1_1_convert.html",
"struct_halide_1_1_internal_1_1_g_t.html#a719d1e243c03196e994aafbe9c8eab17",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_matcher_state.html#a650b50c849f386afe33d060071d2a8b6",
"struct_halide_1_1_internal_1_1_i_r_node.html#a0bc5868014054307d9511017a29f0ad8",
"struct_halide_1_1_internal_1_1_lambda_mutator.html#a3d81a22c9928aea0b0f4c62266f259aa",
"struct_halide_1_1_internal_1_1_min.html#a31b2d54e8cb0dc274b2f28f40160e75c",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dae80155eceb940c89e2de63ad05868db2",
"struct_halide_1_1_internal_1_1_reduction_variable_info.html#a0ed80a539344c9b0073de6c52a0cb7b6",
"struct_halide_1_1_internal_1_1_scope_1_1_push_token.html",
"struct_halide_1_1_internal_1_1_store.html#a0607ec7232499b7e2909fc521497e8e3",
"struct_halide_1_1_range.html#a46c017c3b4b96ea09d57f712994141a6",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_block.html#ae973dc780c9bc6c7365f252b705e117a",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_config.html#a773056e0ac977f597c5d63f59fe3df5e",
"struct_halide_1_1_target.html#a9398276edd5784185e1a08f8a4dfc43fa0d74ff49399ae262e113c2835141ab01",
"struct_halide_1_1_target.html#af2b0caf9e5badd6a8ebe22493752df20a9e33a7f637d78aff56173e2a4fe5dea2",
"struct_halide_1_1float16__t.html#aedb282b3165c30c232288e5c013beca7",
"struct_i_d3_d12_fence_vtbl.html#a4193d8da60cb5f19f83e2325125f77c3",
"struct_i_d3_d12_resource_vtbl.html#aa2bd7d072f652121196922f8ef9df690",
"struct_w_g_p_u_compute_pass_timestamp_writes.html#a04d5d6239ef33f41b68926d37213fa93",
"struct_w_g_p_u_queue_descriptor.html#ae4440340886bc064cded22d87cf38041",
"struct_w_g_p_u_surface_descriptor_from_metal_layer.html#ac38dc059e36470f53a82c9c14333ecbc",
"structhalide__scalar__value__t.html#ab6e55bd50daf1acdb29a2a7b7adb3407",
"vulkan__resources_8h.html#ac591a171d8d07e22d4c11b00a2ca8165"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';