/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc_2_building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc_2_building_halide_with_c_make.html#installing-cmake", [
        [ "Cross-platform", "md_doc_2_building_halide_with_c_make.html#cross-platform", null ],
        [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows", null ],
        [ "macOS", "md_doc_2_building_halide_with_c_make.html#macos", null ],
        [ "Ubuntu Linux", "md_doc_2_building_halide_with_c_make.html#ubuntu-linux", null ],
        [ "Optional: Install Ninja", "md_doc_2_building_halide_with_c_make.html#optional-install-ninja", null ]
      ] ],
      [ "Dependencies", "md_doc_2_building_halide_with_c_make.html#dependencies", [
        [ "Summary", "md_doc_2_building_halide_with_c_make.html#summary", null ],
        [ "Installing dependencies", "md_doc_2_building_halide_with_c_make.html#installing-dependencies", [
          [ "vcpkg", "md_doc_2_building_halide_with_c_make.html#vcpkg", null ],
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-1", null ],
          [ "Homebrew", "md_doc_2_building_halide_with_c_make.html#homebrew", null ],
          [ "Ubuntu / Debian", "md_doc_2_building_halide_with_c_make.html#ubuntu--debian", null ],
          [ "Python", "md_doc_2_building_halide_with_c_make.html#python", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc_2_building_halide_with_c_make.html#building-halide", [
        [ "Basic build", "md_doc_2_building_halide_with_c_make.html#basic-build", [
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-2", null ],
          [ "macOS and Linux", "md_doc_2_building_halide_with_c_make.html#macos-and-linux", null ]
        ] ],
        [ "CMake Presets", "md_doc_2_building_halide_with_c_make.html#cmake-presets", [
          [ "Common presets", "md_doc_2_building_halide_with_c_make.html#common-presets", null ],
          [ "Vcpkg presets", "md_doc_2_building_halide_with_c_make.html#vcpkg-presets", null ],
          [ "Sanitizer presets", "md_doc_2_building_halide_with_c_make.html#sanitizer-presets", null ]
        ] ],
        [ "Build options", "md_doc_2_building_halide_with_c_make.html#build-options", null ],
        [ "Installing", "md_doc_2_building_halide_with_c_make.html#installing", null ]
      ] ],
      [ "Building Halide with pip", "md_doc_2_building_halide_with_c_make.html#building-halide-with-pip", [
        [ "Using ccache with pip builds", "md_doc_2_building_halide_with_c_make.html#using-ccache-with-pip-builds", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc_2_code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc_2_code_style_c_make.html#general-guidelines-and-best-practices", [
        [ "Prohibited commands list", "md_doc_2_code_style_c_make.html#prohibited-commands-list", null ],
        [ "Prohibited variables list", "md_doc_2_code_style_c_make.html#prohibited-variables-list", null ]
      ] ],
      [ "Adding tests", "md_doc_2_code_style_c_make.html#adding-tests", null ],
      [ "Adding apps", "md_doc_2_code_style_c_make.html#adding-apps", null ]
    ] ],
    [ "Fuzz testing", "md_doc_2_fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc_2_fuzz_testing.html#building-fuzz-tests", null ],
      [ "Using the fuzz-harnesses", "md_doc_2_fuzz_testing.html#using-the-fuzz-harnesses", null ],
      [ "Reproducing crashes", "md_doc_2_fuzz_testing.html#reproducing-crashes", null ],
      [ "Adding new fuzz tests", "md_doc_2_fuzz_testing.html#adding-new-fuzz-tests", null ],
      [ "Other useful materials", "md_doc_2_fuzz_testing.html#other-useful-materials", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc_2_halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc_2_halide_c_make_package.html#a-basic-cmake-project", [
        [ "JIT mode", "md_doc_2_halide_c_make_package.html#jit-mode", null ],
        [ "AOT mode", "md_doc_2_halide_c_make_package.html#aot-mode", [
          [ "Autoschedulers", "md_doc_2_halide_c_make_package.html#autoschedulers", null ],
          [ "RunGenMain", "md_doc_2_halide_c_make_package.html#rungenmain", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc_2_halide_c_make_package.html#halide-package-documentation", [
        [ "Components", "md_doc_2_halide_c_make_package.html#components", null ],
        [ "Variables", "md_doc_2_halide_c_make_package.html#variables", null ],
        [ "Imported targets", "md_doc_2_halide_c_make_package.html#imported-targets", null ],
        [ "Functions", "md_doc_2_halide_c_make_package.html#functions", [
          [ "<tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#add_halide_generator", null ],
          [ "<tt>add_halide_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_library", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_python_extension_library", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc_2_halide_c_make_package.html#add_halide_runtime", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc_2_halide_c_make_package.html#cross-compiling", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#use-add_halide_generator", null ],
        [ "Use a super-build", "md_doc_2_halide_c_make_package.html#use-a-super-build", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc_2_halide_c_make_package.html#use-externalproject-directly", null ],
        [ "Use an emulator or run on device", "md_doc_2_halide_c_make_package.html#use-an-emulator-or-run-on-device", null ],
        [ "Bypass CMake", "md_doc_2_halide_c_make_package.html#bypass-cmake", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc_2_hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc_2_hexagon.html#autotoc_md1-obtain-and-build-trunk-llvm-and-clang", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc_2_hexagon.html#autotoc_md2-download-and-install-the-hexagon-sdk-and-hexagon-tools", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc_2_hexagon.html#autotoc_md3-build-and-run-an-example-for-hexagon-hvx", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc_2_hexagon.html#to-build-and-run-the-blur-example-in-halideappsblur-on-android", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc_2_python.html", [
      [ "Acquiring the Python bindings", "md_doc_2_python.html#acquiring-the-python-bindings", null ],
      [ "Building the Python bindings", "md_doc_2_python.html#building-the-python-bindings", [
        [ "Using CMake directly", "md_doc_2_python.html#using-cmake-directly", null ],
        [ "Using wheel infrastructure", "md_doc_2_python.html#using-wheel-infrastructure", null ]
      ] ],
      [ "Documentation and Examples", "md_doc_2_python.html#documentation-and-examples", null ],
      [ "Differences from C++ API", "md_doc_2_python.html#differences-from-c-api", null ],
      [ "Example of Simple Usage", "md_doc_2_python.html#example-of-simple-usage", null ],
      [ "Halide Generators In Python", "md_doc_2_python.html#halide-generators-in-python", [
        [ "Writing a Generator in Python", "md_doc_2_python.html#writing-a-generator-in-python", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc_2_python.html#hlgeneratorname", null ],
          [ "hl.GeneratorParam", "md_doc_2_python.html#hlgeneratorparam", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc_2_python.html#hlinputbuffer-hlinputscalar", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc_2_python.html#hloutputbuffer-hloutputscalar", null ],
          [ "Names", "md_doc_2_python.html#names", null ],
          [ "generate() method", "md_doc_2_python.html#generate-method", null ],
          [ "Types for Inputs and Outputs", "md_doc_2_python.html#types-for-inputs-and-outputs", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc_2_python.html#using-a-generator-for-jit-compilation", null ],
        [ "Using a Generator for AOT compilation", "md_doc_2_python.html#using-a-generator-for-aot-compilation", null ],
        [ "Calling Generator-Produced code from Python", "md_doc_2_python.html#calling-generator-produced-code-from-python", null ],
        [ "Advanced Generator-Related Topics", "md_doc_2_python.html#advanced-generator-related-topics", [
          [ "Generator Aliases", "md_doc_2_python.html#generator-aliases", null ],
          [ "Dynamic Inputs and Outputs", "md_doc_2_python.html#dynamic-inputs-and-outputs", null ],
          [ "Calling a Generator Directly", "md_doc_2_python.html#calling-a-generator-directly", null ],
          [ "The Lifecycle Of A Generator", "md_doc_2_python.html#the-lifecycle-of-a-generator", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc_2_python.html#notable-differences-between-c-and-python-generators", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc_2_python.html#keeping-up-to-date", null ],
      [ "License", "md_doc_2_python.html#license", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc_2_run_gen.html", [
      [ "Overview", "md_doc_2_run_gen.html#overview", null ],
      [ "Benchmarking", "md_doc_2_run_gen.html#benchmarking", null ],
      [ "Measuring Memory Usage", "md_doc_2_run_gen.html#measuring-memory-usage", null ],
      [ "Using RunGen in Make", "md_doc_2_run_gen.html#using-rungen-in-make", null ],
      [ "Known Issues & Caveats", "md_doc_2_run_gen.html#known-issues--caveats", null ]
    ] ],
    [ "Testing", "md_doc_2_testing.html", [
      [ "Organization", "md_doc_2_testing.html#organization", null ],
      [ "Debugging with LLDB", "md_doc_2_testing.html#debugging-with-lldb", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc_2_vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc_2_vulkan.html#compiling-halide-wvulkan-support", null ],
      [ "Vulkan Runtime Environment:", "md_doc_2_vulkan.html#vulkan-runtime-environment", [
        [ "Windows", "md_doc_2_vulkan.html#windows-3", null ],
        [ "Linux", "md_doc_2_vulkan.html#linux", null ],
        [ "Mac", "md_doc_2_vulkan.html#mac", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc_2_vulkan.html#testing-your-vulkan-environment", null ],
      [ "Targetting Vulkan", "md_doc_2_vulkan.html#targetting-vulkan", null ],
      [ "Useful Runtime Environment Variables", "md_doc_2_vulkan.html#useful-runtime-environment-variables", null ],
      [ "Debug Environment Variables", "md_doc_2_vulkan.html#debug-environment-variables", null ],
      [ "Current Status", "md_doc_2_vulkan.html#current-status", null ],
      [ "Caveats:", "md_doc_2_vulkan.html#caveats", null ],
      [ "Known TODO:", "md_doc_2_vulkan.html#known-todo", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc_2_web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc_2_web_assembly.html#additional-tooling-requirements", null ],
      [ "AOT Limitations", "md_doc_2_web_assembly.html#aot-limitations", null ],
      [ "JIT Limitations", "md_doc_2_web_assembly.html#jit-limitations", [
        [ "Using V8 as the interpreter", "md_doc_2_web_assembly.html#using-v8-as-the-interpreter", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc_2_web_assembly.html#to-use-halide-for-webassembly", [
        [ "Enabling wasm JIT", "md_doc_2_web_assembly.html#enabling-wasm-jit", null ],
        [ "Enabling wasm AOT", "md_doc_2_web_assembly.html#enabling-wasm-aot", null ]
      ] ],
      [ "Running benchmarks", "md_doc_2_web_assembly.html#running-benchmarks", null ],
      [ "Using Threads", "md_doc_2_web_assembly.html#using-threads", null ],
      [ "Known Limitations And Caveats", "md_doc_2_web_assembly.html#known-limitations-and-caveats", null ],
      [ "Known TODO:", "md_doc_2_web_assembly.html#known-todo-1", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc_2_web_g_p_u.html", [
      [ "Known limitations", "md_doc_2_web_g_p_u.html#known-limitations", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-with-webassembly-via-emscripten-hl_targetwasm-32-wasmrt-webgpu", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-natively-hl_targethost-webgpu", null ],
      [ "Setting up Dawn", "md_doc_2_web_g_p_u.html#setting-up-dawn", null ],
      [ "Updating mini_webgpu.h", "md_doc_2_web_g_p_u.html#updating-mini_webgpuh", null ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Symbols", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#a8e2154ce76c37412e7d74c0c7fe5fecb",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2ae8b4b40ec3622e371789b790caabc083",
"_halide_runtime_8h.html",
"_halide_runtime_8h.html#ab199bb9f42e5a36069af2e8b08994eef",
"_hexagon_optimize_8h.html#ad61e99863aa9fd2833e535440b632093",
"_i_r_operator_8h.html#a082d3bda0d60128ae127d0879e7e38c9",
"_i_r_operator_8h.html#af7df709582bdb9d7844efa9cd6b69625",
"_monotonic_8h.html#aecd75538cec762a0ec020c81708260b6",
"_type_8h.html#a0fbca831439bde92087c2821e1a76df7",
"android__ioctl_8h.html#aefe531e01b900d7ec9446d8a72060870",
"class_halide_1_1_default_cost_model.html#a7e1e8276960aefbacf55c13990372195",
"class_halide_1_1_func.html#a9d619f2d0111ea5bf640781d1324d050",
"class_halide_1_1_generator_context.html#a697a82ac8ecc83494e7cdbd31ac78c44",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a5c608676745faf2ccee7645f81473b49",
"class_halide_1_1_internal_1_1_closure.html#aaf0bb1168612d9b2af5769112f9d4800",
"class_halide_1_1_internal_1_1_code_gen___c.html#a9f70fa702a75f4274bcfde028742bb94",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aa0835166d9c7648edcfbbc0c30b209a7",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a5bfbe42f3e2108b471d0070dba2a7564",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ad9c4f607250525b19bd9e1d2b5bd6515",
"class_halide_1_1_internal_1_1_code_gen___posix.html#ad4225e6bea8519d4455fdcb2125fb6a4",
"class_halide_1_1_internal_1_1_elf_1_1_object.html#ad5335d68a32ccb44c3f1902575e5e4d9",
"class_halide_1_1_internal_1_1_elf_1_1iterator__range.html#ade11085dc7adeaf0aa4298bde20baa8c",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a42ff7d77a8e943b932aa69affcdf2153",
"class_halide_1_1_internal_1_1_generator_factory_provider.html#a2a8ca62136fbc1ae600dde93c3dd6173",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a1059ceb2f82327ad40100497f2682eef",
"class_halide_1_1_internal_1_1_generator_param_base.html#a32c4599bcf53cf400e0d76348deb16c0",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a48185da0070e1b2f626f7d1641365321",
"class_halide_1_1_internal_1_1_i_r_printer.html#ade61335e8a16e1c1a80ea0f4b16a310c",
"class_halide_1_1_internal_1_1_report_base.html",
"class_halide_1_1_internal_1_1_small_stack.html#a73cad14d6d112ff0632804c873e41b74",
"class_halide_1_1_module.html#ab98199d5c33a19f77ced5345e171bbf6",
"class_halide_1_1_parameter.html#aac8c13e44f685f1ab404968e99d7177a",
"class_halide_1_1_runtime_1_1_buffer.html#a0f0cb15e2ee77d2f22bde4886f92ae12",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a14f2d29aeb96b7933eb75cce6aa0a8e5",
"class_halide_1_1_runtime_1_1_internal_1_1_pointer_table.html#aefcbe0c127e33fee977e3caad8a58c59",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#a68db7c7c26184b38766a49a322dbf6d8",
"class_perfect_hash_map.html#abaa4abf26a288b4927745f2705abb188",
"functions_vars_b.html",
"md_doc_2_building_halide_with_c_make.html#windows",
"mini__cl_8h.html#a37719cde5e48a7e0298838dcddce0d52",
"mini__cl_8h.html#ac35f540118c8a516deb01bd04b219642",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaaaf6c5ded38a898acb9d7aee15cd6df32",
"mini__d3d12_8h.html#a40a835029cd0b8478f18c002ab00b3b0",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcab9ef340c3c3b1119602397ea818e33a8",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335da2bba38bbf50bc28c503db4e32e8082c6",
"mini__d3d12_8h.html#ad89d726f42e6e53f157e0ddfcf4e0c76a509d6c410615622bb468a8d60a528e51",
"mini__hexagon__dma_8h.html#a45cc21a5128889d0dbf34e64fb482e95",
"mini__webgpu_8h.html#a0f20513eb24158a4d0901f2c4b610f34ae88c4eb13cf991406873b66ff9eff936",
"mini__webgpu_8h.html#a4fa2e4c086de6b66ecb208fc2dbd5689",
"mini__webgpu_8h.html#a7fa2c2627783fe742a84ebb6c3618726a3734040fb1bc55730944e56b46a711ba",
"mini__webgpu_8h.html#acc5a7c26f6dccd8f5b22a520090520d9a411107bb602df1d12561ff6d820ed79c",
"namespace_halide.html#a1f99adc84a7324351d6037eacb3f9157",
"namespace_halide.html#aab45b50a1d7838663e5cfaceff50d8b7",
"namespace_halide_1_1_internal.html#a1b0244f4d3e877af92bb3326b5ba74d2",
"namespace_halide_1_1_internal.html#a819144ed78ee773e7fbcd5271c9d1253",
"namespace_halide_1_1_internal.html#ae81d78fd7f3115750e17167ebf0fe920",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a60ababe61b897e02458abaa51ff96952",
"namespace_halide_1_1_runtime_1_1_internal.html#afd2c21329a7cc51d6dbd1879b248a9d4",
"namespacemembers.html",
"struct_d3_d12___b_o_x.html#a34971d0b5026ebbd5c607b033cc55a81",
"struct_d3_d12___r_o_o_t___d_e_s_c_r_i_p_t_o_r___t_a_b_l_e.html#aff525f7a78655a98e7bd29b969153b4d",
"struct_d_x_g_i___a_d_a_p_t_e_r___d_e_s_c.html#a935c2beaa843360788eb7fe589d73e28",
"struct_halide_1_1_fuse_loop_level.html",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#a34536926a85b80aecb33f76650e65a0d",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#a4d551888f91ad90dc6f5954f18c0aadf",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#aa36429ae4c9844b103b1e437c1ff6214",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_mem_traits_3_01_local_mem_01_4.html#a988e7f0842f37884bfa9db3e00659b39",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a653e967c2fb58266b024cb90c1682844",
"struct_halide_1_1_internal_1_1_bound.html",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974acde73dc8fc73917461e5fee3e45ef9cc",
"struct_halide_1_1_internal_1_1_constant_interval.html#aede731f3e07b6c4d7e1feedb8ed0dc7f",
"struct_halide_1_1_internal_1_1_g_e.html#a5863abbe82771dde82bc841af045c568",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_matcher_state.html#a45f60de3b6d2829e5fa94860725997af",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1enable__if__pattern.html",
"struct_halide_1_1_internal_1_1_lambda_mutator.html#a32eeaae623bc558e704555ef02e48e65",
"struct_halide_1_1_internal_1_1_max.html#aaedd2bb10d035b889abcd4820a41a89d",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dae0626222614bdee31951d84c64e5e9ff",
"struct_halide_1_1_internal_1_1_reduction_variable_1_1_compare.html",
"struct_halide_1_1_internal_1_1_schedule_features.html#afa595b8814fc1a5fab0acaff9baa3225",
"struct_halide_1_1_internal_1_1_storage_dim.html#a6b61ad1459fa5cb79d87dbbafad4b5fc",
"struct_halide_1_1_py_torch_1_1_user_context.html#aee5e16a7421a59268f302f87f7580ca8",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_block.html#a302782efa91809f7f2440c6162af668e",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_dispatch_data.html#ab7761a952ca97987a28b57b23557ac1d",
"struct_halide_1_1_target.html#a9398276edd5784185e1a08f8a4dfc43fa027631ce082530506684842b44123b8a",
"struct_halide_1_1_target.html#af2b0caf9e5badd6a8ebe22493752df20a33d246944800a2b478899132d76a95b2",
"struct_i_d3_d12_command_queue_vtbl.html#a6a0b4b1ee1d12b01dc7d166251d0ecd1",
"struct_i_d3_d12_graphics_command_list_vtbl.html#a4610ff396ab3ddd43cb252e6b910f035",
"struct_i_d_x_g_i_adapter_vtbl.html#a98a0f0568485f771b43816099f460abb",
"struct_w_g_p_u_dawn_encoder_internal_usage_descriptor.html",
"struct_w_g_p_u_render_pass_pixel_local_storage.html#a3a72db1fc1c281d9c5a234ed7980d9fc",
"struct_w_g_p_u_texture_descriptor.html#ac737fb715b907e6da34f491fbd18b8c5",
"structst_dma_wrapper___dma_transfer_setup.html#ad0e6d40d19d9f50b241b7beb49c78a62"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';