/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc__building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc__building_halide_with_c_make.html#autotoc_md1", [
        [ "Cross-platform", "md_doc__building_halide_with_c_make.html#autotoc_md2", null ],
        [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md3", null ],
        [ "macOS", "md_doc__building_halide_with_c_make.html#autotoc_md4", null ],
        [ "Ubuntu Linux", "md_doc__building_halide_with_c_make.html#autotoc_md5", null ],
        [ "Optional: Install Ninja", "md_doc__building_halide_with_c_make.html#autotoc_md6", null ]
      ] ],
      [ "Dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md7", [
        [ "Summary", "md_doc__building_halide_with_c_make.html#autotoc_md8", null ],
        [ "Installing dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md9", [
          [ "vcpkg", "md_doc__building_halide_with_c_make.html#autotoc_md10", null ],
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md11", null ],
          [ "Homebrew", "md_doc__building_halide_with_c_make.html#autotoc_md12", null ],
          [ "Ubuntu / Debian", "md_doc__building_halide_with_c_make.html#autotoc_md13", null ],
          [ "Python", "md_doc__building_halide_with_c_make.html#autotoc_md14", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc__building_halide_with_c_make.html#autotoc_md15", [
        [ "Basic build", "md_doc__building_halide_with_c_make.html#autotoc_md16", [
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md17", null ],
          [ "macOS and Linux", "md_doc__building_halide_with_c_make.html#autotoc_md18", null ]
        ] ],
        [ "CMake Presets", "md_doc__building_halide_with_c_make.html#autotoc_md19", [
          [ "Common presets", "md_doc__building_halide_with_c_make.html#autotoc_md20", null ],
          [ "Vcpkg presets", "md_doc__building_halide_with_c_make.html#autotoc_md21", null ],
          [ "Sanitizer presets", "md_doc__building_halide_with_c_make.html#autotoc_md22", null ]
        ] ],
        [ "Build options", "md_doc__building_halide_with_c_make.html#autotoc_md23", null ],
        [ "Installing", "md_doc__building_halide_with_c_make.html#autotoc_md24", null ]
      ] ],
      [ "Building Halide with pip", "md_doc__building_halide_with_c_make.html#autotoc_md25", [
        [ "Using ccache with pip builds", "md_doc__building_halide_with_c_make.html#autotoc_md26", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc__code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc__code_style_c_make.html#autotoc_md28", [
        [ "Prohibited commands list", "md_doc__code_style_c_make.html#autotoc_md29", null ],
        [ "Prohibited variables list", "md_doc__code_style_c_make.html#autotoc_md30", null ]
      ] ],
      [ "Adding tests", "md_doc__code_style_c_make.html#autotoc_md31", null ],
      [ "Adding apps", "md_doc__code_style_c_make.html#autotoc_md32", null ]
    ] ],
    [ "Fuzz testing", "md_doc__fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc__fuzz_testing.html#autotoc_md34", null ],
      [ "Using the fuzz-harnesses", "md_doc__fuzz_testing.html#autotoc_md35", null ],
      [ "Reproducing crashes", "md_doc__fuzz_testing.html#autotoc_md36", null ],
      [ "Adding new fuzz tests", "md_doc__fuzz_testing.html#autotoc_md37", null ],
      [ "Other useful materials", "md_doc__fuzz_testing.html#autotoc_md38", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc__halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc__halide_c_make_package.html#autotoc_md40", [
        [ "JIT mode", "md_doc__halide_c_make_package.html#autotoc_md41", null ],
        [ "AOT mode", "md_doc__halide_c_make_package.html#autotoc_md42", [
          [ "Autoschedulers", "md_doc__halide_c_make_package.html#autotoc_md43", null ],
          [ "RunGenMain", "md_doc__halide_c_make_package.html#autotoc_md44", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc__halide_c_make_package.html#autotoc_md45", [
        [ "Components", "md_doc__halide_c_make_package.html#autotoc_md46", null ],
        [ "Variables", "md_doc__halide_c_make_package.html#autotoc_md47", null ],
        [ "Imported targets", "md_doc__halide_c_make_package.html#autotoc_md48", null ],
        [ "Functions", "md_doc__halide_c_make_package.html#autotoc_md49", [
          [ "<tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md50", null ],
          [ "<tt>add_halide_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md51", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md52", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc__halide_c_make_package.html#autotoc_md53", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc__halide_c_make_package.html#autotoc_md54", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md55", null ],
        [ "Use a super-build", "md_doc__halide_c_make_package.html#autotoc_md56", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc__halide_c_make_package.html#autotoc_md57", null ],
        [ "Use an emulator or run on device", "md_doc__halide_c_make_package.html#autotoc_md58", null ],
        [ "Bypass CMake", "md_doc__halide_c_make_package.html#autotoc_md59", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc__hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc__hexagon.html#autotoc_md61", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc__hexagon.html#autotoc_md62", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc__hexagon.html#autotoc_md63", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc__hexagon.html#autotoc_md64", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc__python.html", [
      [ "Acquiring the Python bindings", "md_doc__python.html#autotoc_md66", null ],
      [ "Building the Python bindings", "md_doc__python.html#autotoc_md67", [
        [ "Using CMake directly", "md_doc__python.html#autotoc_md68", null ],
        [ "Using wheel infrastructure", "md_doc__python.html#autotoc_md69", null ]
      ] ],
      [ "Documentation and Examples", "md_doc__python.html#autotoc_md70", null ],
      [ "Differences from C++ API", "md_doc__python.html#autotoc_md71", null ],
      [ "Example of Simple Usage", "md_doc__python.html#autotoc_md72", null ],
      [ "Halide Generators In Python", "md_doc__python.html#autotoc_md73", [
        [ "Writing a Generator in Python", "md_doc__python.html#autotoc_md74", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc__python.html#autotoc_md75", null ],
          [ "hl.GeneratorParam", "md_doc__python.html#autotoc_md76", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc__python.html#autotoc_md77", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc__python.html#autotoc_md78", null ],
          [ "Names", "md_doc__python.html#autotoc_md79", null ],
          [ "generate() method", "md_doc__python.html#autotoc_md80", null ],
          [ "Types for Inputs and Outputs", "md_doc__python.html#autotoc_md81", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc__python.html#autotoc_md82", null ],
        [ "Using a Generator for AOT compilation", "md_doc__python.html#autotoc_md83", null ],
        [ "Calling Generator-Produced code from Python", "md_doc__python.html#autotoc_md84", null ],
        [ "Advanced Generator-Related Topics", "md_doc__python.html#autotoc_md85", [
          [ "Generator Aliases", "md_doc__python.html#autotoc_md86", null ],
          [ "Dynamic Inputs and Outputs", "md_doc__python.html#autotoc_md87", null ],
          [ "Calling a Generator Directly", "md_doc__python.html#autotoc_md88", null ],
          [ "The Lifecycle Of A Generator", "md_doc__python.html#autotoc_md89", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc__python.html#autotoc_md90", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc__python.html#autotoc_md91", null ],
      [ "License", "md_doc__python.html#autotoc_md92", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc__run_gen.html", [
      [ "Overview", "md_doc__run_gen.html#autotoc_md94", null ],
      [ "Benchmarking", "md_doc__run_gen.html#autotoc_md95", null ],
      [ "Measuring Memory Usage", "md_doc__run_gen.html#autotoc_md96", null ],
      [ "Using RunGen in Make", "md_doc__run_gen.html#autotoc_md97", null ],
      [ "Known Issues & Caveats", "md_doc__run_gen.html#autotoc_md98", null ]
    ] ],
    [ "Testing", "md_doc__testing.html", [
      [ "Organization", "md_doc__testing.html#autotoc_md100", null ],
      [ "Debugging with LLDB", "md_doc__testing.html#autotoc_md101", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc__vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc__vulkan.html#autotoc_md103", null ],
      [ "Vulkan Runtime Environment:", "md_doc__vulkan.html#autotoc_md104", [
        [ "Windows", "md_doc__vulkan.html#autotoc_md105", null ],
        [ "Linux", "md_doc__vulkan.html#autotoc_md106", null ],
        [ "Mac", "md_doc__vulkan.html#autotoc_md107", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc__vulkan.html#autotoc_md108", null ],
      [ "Targetting Vulkan", "md_doc__vulkan.html#autotoc_md109", null ],
      [ "Useful Runtime Environment Variables", "md_doc__vulkan.html#autotoc_md110", null ],
      [ "Debug Environment Variables", "md_doc__vulkan.html#autotoc_md111", null ],
      [ "Current Status", "md_doc__vulkan.html#autotoc_md112", null ],
      [ "Caveats:", "md_doc__vulkan.html#autotoc_md113", null ],
      [ "Known TODO:", "md_doc__vulkan.html#autotoc_md114", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc__web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc__web_assembly.html#autotoc_md116", null ],
      [ "AOT Limitations", "md_doc__web_assembly.html#autotoc_md117", null ],
      [ "JIT Limitations", "md_doc__web_assembly.html#autotoc_md118", [
        [ "Using V8 as the interpreter", "md_doc__web_assembly.html#autotoc_md119", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc__web_assembly.html#autotoc_md120", [
        [ "Enabling wasm JIT", "md_doc__web_assembly.html#autotoc_md121", null ],
        [ "Enabling wasm AOT", "md_doc__web_assembly.html#autotoc_md122", null ]
      ] ],
      [ "Running benchmarks", "md_doc__web_assembly.html#autotoc_md123", null ],
      [ "Using Threads", "md_doc__web_assembly.html#autotoc_md124", null ],
      [ "Known Limitations And Caveats", "md_doc__web_assembly.html#autotoc_md125", null ],
      [ "Known TODO:", "md_doc__web_assembly.html#autotoc_md126", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc__web_g_p_u.html", [
      [ "Known limitations", "md_doc__web_g_p_u.html#autotoc_md128", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md129", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md130", null ],
      [ "Setting up Dawn", "md_doc__web_g_p_u.html#autotoc_md131", null ],
      [ "Updating mini_webgpu.h", "md_doc__web_g_p_u.html#autotoc_md132", null ]
    ] ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#aaafd1baeff31b7d0293b95f041e0d116",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2af803729628adf4199f224c2a225038e9",
"_halide_runtime_8h.html#a02da52a04bf26d2636c9e70dd73b2fac",
"_halide_runtime_8h.html#ab3e13f5910a047d1908532367ce0b21f",
"_hexagon_optimize_8h.html#af6b52d96bb5a9b758cbaf557e35f4695",
"_i_r_operator_8h.html#a0c7bd26b46c10f2c3a6fc36da6a89518",
"_i_r_operator_8h.html#afc9c07e39289b14103ccd45ee31630a3",
"_offload_g_p_u_loops_8h.html#aad273923c5480df0e3753e3a70d240e6",
"_type_8h.html#a3307da3cd7adc9594a3c9b987b70b55b",
"block__allocator_8h.html",
"class_halide_1_1_default_cost_model.html#a842c7b068634e5f3cee34dcabc52ce42",
"class_halide_1_1_func.html#aa203357492e584a49694d02372d2c557",
"class_halide_1_1_generator_context.html#aea018cd01a6644d337ee44aa006679cf",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a9d59a6799c55c674ca100581889034e9",
"class_halide_1_1_internal_1_1_closure.html#abb0a6b6d244182ba97684afd1915d8a8",
"class_halide_1_1_internal_1_1_code_gen___c.html#aa9d423572079a0db3dc4210d0daf54b9",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aaf85bcd31b07f45d3e8f1dc64d846176",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a614d085fffcb0ef0c1aef52868b563f4",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ae2b81caf2b65dcf5e522503c1f4af37e",
"class_halide_1_1_internal_1_1_code_gen___posix.html#af0e1a3b165a5d84e2482a6bde1a21f76",
"class_halide_1_1_internal_1_1_elf_1_1_relocation.html#a0061bb5c115b9a4e1adbb1bee8ca771d",
"class_halide_1_1_internal_1_1_func_schedule.html#a0bf19917d7f275dfa9b453dce45bf344",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a8653eef4cf7dd4fd556e269751b03908",
"class_halide_1_1_internal_1_1_generator_input___arithmetic.html#a077420a8f6eaff05fb01875354996ef7",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a8d181f5a1408085b4d556883de5cd344",
"class_halide_1_1_internal_1_1_generator_param_base.html#a7eaf666933890a88ccde8ad9a1d078e1",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a7bed52b9fe426612b7470d27fd897b99",
"class_halide_1_1_internal_1_1_i_r_visitor.html",
"class_halide_1_1_internal_1_1_scope.html#a1171c247a83f0022c003d2bf1e01972e",
"class_halide_1_1_internal_1_1_small_stack_3_01void_01_4.html#a2a3c0a4ba0404cde4a7c6e74886a9349",
"class_halide_1_1_module.html#af47fcf2cef7bc6c6c951fa70521fe6fe",
"class_halide_1_1_parameter.html#ac9d912036e9e41ccd70550e2d538bf50",
"class_halide_1_1_runtime_1_1_buffer.html#a29684a67bb84956fc25fc028c436e951",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a70e7ebdfd1ee276af03dcacd1de249ee",
"class_halide_1_1_runtime_1_1_internal_1_1_printer_base.html#a2e9bff2e839e138464a58e3c4457ee78",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#aac071a3f99aa3e9f92435f705be70b02",
"classcmdline_1_1parser.html#a122aab1fb389f16170397971be1e75b6",
"functions_vars_v.html",
"md_doc__halide_c_make_package.html#autotoc_md43",
"mini__cl_8h.html#a3fd815a4421e3f7f26ee2f1c388da8c7",
"mini__cl_8h.html#accc650acf63c159fd70b97ad10b31138",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaae8aeac2820ce2047cbd66eab11fb83ca",
"mini__d3d12_8h.html#a4bd9ba536085c94c7e71193401fbb9dfa00025dc24d55951aa7c4e5deea673812",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcaed40fce638f1826811fa45a986abc728",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335da77468c053ad065c8679a9fffbe7181f6",
"mini__d3d12_8h.html#ade94505e6a72bf28344f6fab959a7333",
"mini__hexagon__dma_8h.html#ab7903878916593daecbeb95b98115ab0",
"mini__webgpu_8h.html#a1357906a33685f027e4546af573d8508",
"mini__webgpu_8h.html#a57a04e266142c3e6f3fd131481b2ec3fa07bef0dc756cafaf2f1f125a7fc32a6f",
"mini__webgpu_8h.html#a8103b83ed72d7a17e80102c8119d0451",
"mini__webgpu_8h.html#ad29983547909bf5e9875d82212af882fa35f216b3da103f03863f49c0152da057",
"namespace_halide.html#a28d7f25e89e1f74d7d76e370161f7358",
"namespace_halide.html#ab7126caa58fad82bb502a72f7ba72dae",
"namespace_halide_1_1_internal.html#a22e19379ffc6e5b02608a6d6b985194e",
"namespace_halide_1_1_internal.html#a8803d2593422e45d64b2d15429cfde0d",
"namespace_halide_1_1_internal.html#aee9e0b8e5376e2294d74ded8e7de9ef2a2e5af173c7126a0e6f6bc996222386c7",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a7ac4c8454880585481070c83840d30d3",
"namespace_halide_1_1_runtime_1_1_internal_1_1_cuda.html#a2f191c22706ed27f2c64f0e1ab3d4ab9a44098f22001f11e8e9b9c0eff1cb7cad",
"namespacemembers_func_l.html",
"struct_d3_d12___c_a_c_h_e_d___p_i_p_e_l_i_n_e___s_t_a_t_e.html#ab791bad038ae7180a73661d37e58553c",
"struct_d3_d12___r_o_o_t___s_i_g_n_a_t_u_r_e___d_e_s_c.html#afc2193a48f8fbdc0d8164fb469358679",
"struct_halide_1_1_argument.html#a19465e45c44f1ba93484662d09706107",
"struct_halide_1_1_internal_1_1_abstract_generator_1_1_arg_info.html#a8ade485b773fc2c7da6610c36fc84d4f",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#ac2bec52f6010681af34cc4ca86295aad",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#aeb068bb4e663ac9346944443bef40a41",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#ac2409ae36da8ad0bdda29923e879886c",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_optional_rational.html#a1c349c4c9de3bfd076db1550e96006f4",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a88bf5e237b76ea441d12703ee2560dc3",
"struct_halide_1_1_internal_1_1_box.html#a4d47b4be34d44545b224591ca716f0f9",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974aecc18b09944a0c1c61d037f10dd7fdbf",
"struct_halide_1_1_internal_1_1_device_argument.html",
"struct_halide_1_1_internal_1_1_i_r_graph_deep_compare.html#aca8de8cb5feb9232ff3d9b57c658d712",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_negate_op.html#ade3fcdde5b78cb5332ee734f9b2a39f4",
"struct_halide_1_1_internal_1_1_indentation.html#a1b9adb9f92b1d1dec988857daa50a1d1",
"struct_halide_1_1_internal_1_1_lowered_func.html#aeac32842105eb81a711171592174faf6",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dadc33066c3993e0d50896e533fd692ce0",
"struct_halide_1_1_internal_1_1_reduction_variable.html#a4562bcb8f14e1939076a2806dc6c0915",
"struct_halide_1_1_internal_1_1_schedule_features.html#af55909b02a1fc829b2b23f300c5676d8",
"struct_halide_1_1_internal_1_1_storage_dim.html#a0157f5cf508314a37bfc48485e4cb9bc",
"struct_halide_1_1_py_torch_1_1_user_context.html",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_arena_1_1_config.html#a4c71c995466021497d9ca5cbe9107fda",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_dispatch_data.html#a38cb99b55c892d0a574095a8b8c32bb1",
"struct_halide_1_1_target.html#a8eaefa280388ad4813a83fd60a2702b1",
"struct_halide_1_1_target.html#af17585cfd5ec92952fd361117d89d4b1ae6d33003db3020c4c578c645239f2973",
"struct_halide_1_1float16__t.html#abc4e4c40cb51efbf9d383d95ea7e5672",
"struct_i_d3_d12_device_vtbl.html#af4b44deec68b36cec5341eef33a1d50c",
"struct_i_d3_d12_resource_vtbl.html#a49d657d9cc23f2919748c225aa38599b",
"struct_w_g_p_u_compilation_message.html#a83f87ec78f7329112196787209312237",
"struct_w_g_p_u_programmable_stage_descriptor.html",
"struct_w_g_p_u_supported_limits.html#adb184b66eb4ffe9a174c39082351ced9",
"structhalide__pseudostack__slot__t.html",
"vulkan__memory_8h.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';