/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc_2_building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc_2_building_halide_with_c_make.html#installing-cmake", [
        [ "Cross-platform", "md_doc_2_building_halide_with_c_make.html#cross-platform", null ],
        [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows", null ],
        [ "macOS", "md_doc_2_building_halide_with_c_make.html#macos", null ],
        [ "Ubuntu Linux", "md_doc_2_building_halide_with_c_make.html#ubuntu-linux", null ],
        [ "Optional: Install Ninja", "md_doc_2_building_halide_with_c_make.html#optional-install-ninja", null ]
      ] ],
      [ "Dependencies", "md_doc_2_building_halide_with_c_make.html#dependencies", [
        [ "Summary", "md_doc_2_building_halide_with_c_make.html#summary", null ],
        [ "Installing dependencies", "md_doc_2_building_halide_with_c_make.html#installing-dependencies", [
          [ "vcpkg", "md_doc_2_building_halide_with_c_make.html#vcpkg", null ],
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-1", null ],
          [ "Homebrew", "md_doc_2_building_halide_with_c_make.html#homebrew", null ],
          [ "Ubuntu / Debian", "md_doc_2_building_halide_with_c_make.html#ubuntu--debian", null ],
          [ "Python", "md_doc_2_building_halide_with_c_make.html#python", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc_2_building_halide_with_c_make.html#building-halide", [
        [ "Basic build", "md_doc_2_building_halide_with_c_make.html#basic-build", [
          [ "Windows", "md_doc_2_building_halide_with_c_make.html#windows-2", null ],
          [ "macOS and Linux", "md_doc_2_building_halide_with_c_make.html#macos-and-linux", null ]
        ] ],
        [ "CMake Presets", "md_doc_2_building_halide_with_c_make.html#cmake-presets", [
          [ "Common presets", "md_doc_2_building_halide_with_c_make.html#common-presets", null ],
          [ "Vcpkg presets", "md_doc_2_building_halide_with_c_make.html#vcpkg-presets", null ],
          [ "Sanitizer presets", "md_doc_2_building_halide_with_c_make.html#sanitizer-presets", null ]
        ] ],
        [ "Build options", "md_doc_2_building_halide_with_c_make.html#build-options", null ],
        [ "Installing", "md_doc_2_building_halide_with_c_make.html#installing", null ]
      ] ],
      [ "Building Halide with pip", "md_doc_2_building_halide_with_c_make.html#building-halide-with-pip", [
        [ "Using ccache with pip builds", "md_doc_2_building_halide_with_c_make.html#using-ccache-with-pip-builds", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc_2_code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc_2_code_style_c_make.html#general-guidelines-and-best-practices", [
        [ "Prohibited commands list", "md_doc_2_code_style_c_make.html#prohibited-commands-list", null ],
        [ "Prohibited variables list", "md_doc_2_code_style_c_make.html#prohibited-variables-list", null ]
      ] ],
      [ "Adding tests", "md_doc_2_code_style_c_make.html#adding-tests", null ],
      [ "Adding apps", "md_doc_2_code_style_c_make.html#adding-apps", null ]
    ] ],
    [ "Fuzz testing", "md_doc_2_fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc_2_fuzz_testing.html#building-fuzz-tests", null ],
      [ "Using the fuzz-harnesses", "md_doc_2_fuzz_testing.html#using-the-fuzz-harnesses", null ],
      [ "Reproducing crashes", "md_doc_2_fuzz_testing.html#reproducing-crashes", null ],
      [ "Adding new fuzz tests", "md_doc_2_fuzz_testing.html#adding-new-fuzz-tests", null ],
      [ "Other useful materials", "md_doc_2_fuzz_testing.html#other-useful-materials", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc_2_halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc_2_halide_c_make_package.html#a-basic-cmake-project", [
        [ "JIT mode", "md_doc_2_halide_c_make_package.html#jit-mode", null ],
        [ "AOT mode", "md_doc_2_halide_c_make_package.html#aot-mode", [
          [ "Autoschedulers", "md_doc_2_halide_c_make_package.html#autoschedulers", null ],
          [ "RunGenMain", "md_doc_2_halide_c_make_package.html#rungenmain", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc_2_halide_c_make_package.html#halide-package-documentation", [
        [ "Components", "md_doc_2_halide_c_make_package.html#components", null ],
        [ "Variables", "md_doc_2_halide_c_make_package.html#variables", null ],
        [ "Imported targets", "md_doc_2_halide_c_make_package.html#imported-targets", null ],
        [ "Functions", "md_doc_2_halide_c_make_package.html#functions", [
          [ "<tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#add_halide_generator", null ],
          [ "<tt>add_halide_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_library", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc_2_halide_c_make_package.html#add_halide_python_extension_library", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc_2_halide_c_make_package.html#add_halide_runtime", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc_2_halide_c_make_package.html#cross-compiling", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc_2_halide_c_make_package.html#use-add_halide_generator", null ],
        [ "Use a super-build", "md_doc_2_halide_c_make_package.html#use-a-super-build", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc_2_halide_c_make_package.html#use-externalproject-directly", null ],
        [ "Use an emulator or run on device", "md_doc_2_halide_c_make_package.html#use-an-emulator-or-run-on-device", null ],
        [ "Bypass CMake", "md_doc_2_halide_c_make_package.html#bypass-cmake", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc_2_hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc_2_hexagon.html#autotoc_md1-obtain-and-build-trunk-llvm-and-clang", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc_2_hexagon.html#autotoc_md2-download-and-install-the-hexagon-sdk-and-hexagon-tools", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc_2_hexagon.html#autotoc_md3-build-and-run-an-example-for-hexagon-hvx", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc_2_hexagon.html#to-build-and-run-the-blur-example-in-halideappsblur-on-android", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc_2_python.html", [
      [ "Acquiring the Python bindings", "md_doc_2_python.html#acquiring-the-python-bindings", null ],
      [ "Building the Python bindings", "md_doc_2_python.html#building-the-python-bindings", [
        [ "Using CMake directly", "md_doc_2_python.html#using-cmake-directly", null ],
        [ "Using wheel infrastructure", "md_doc_2_python.html#using-wheel-infrastructure", null ]
      ] ],
      [ "Documentation and Examples", "md_doc_2_python.html#documentation-and-examples", null ],
      [ "Differences from C++ API", "md_doc_2_python.html#differences-from-c-api", null ],
      [ "Example of Simple Usage", "md_doc_2_python.html#example-of-simple-usage", null ],
      [ "Halide Generators In Python", "md_doc_2_python.html#halide-generators-in-python", [
        [ "Writing a Generator in Python", "md_doc_2_python.html#writing-a-generator-in-python", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc_2_python.html#hlgeneratorname", null ],
          [ "hl.GeneratorParam", "md_doc_2_python.html#hlgeneratorparam", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc_2_python.html#hlinputbuffer-hlinputscalar", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc_2_python.html#hloutputbuffer-hloutputscalar", null ],
          [ "Names", "md_doc_2_python.html#names", null ],
          [ "generate() method", "md_doc_2_python.html#generate-method", null ],
          [ "Types for Inputs and Outputs", "md_doc_2_python.html#types-for-inputs-and-outputs", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc_2_python.html#using-a-generator-for-jit-compilation", null ],
        [ "Using a Generator for AOT compilation", "md_doc_2_python.html#using-a-generator-for-aot-compilation", null ],
        [ "Calling Generator-Produced code from Python", "md_doc_2_python.html#calling-generator-produced-code-from-python", null ],
        [ "Advanced Generator-Related Topics", "md_doc_2_python.html#advanced-generator-related-topics", [
          [ "Generator Aliases", "md_doc_2_python.html#generator-aliases", null ],
          [ "Dynamic Inputs and Outputs", "md_doc_2_python.html#dynamic-inputs-and-outputs", null ],
          [ "Calling a Generator Directly", "md_doc_2_python.html#calling-a-generator-directly", null ],
          [ "The Lifecycle Of A Generator", "md_doc_2_python.html#the-lifecycle-of-a-generator", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc_2_python.html#notable-differences-between-c-and-python-generators", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc_2_python.html#keeping-up-to-date", null ],
      [ "License", "md_doc_2_python.html#license", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc_2_run_gen.html", [
      [ "Overview", "md_doc_2_run_gen.html#overview", null ],
      [ "Benchmarking", "md_doc_2_run_gen.html#benchmarking", null ],
      [ "Measuring Memory Usage", "md_doc_2_run_gen.html#measuring-memory-usage", null ],
      [ "Using RunGen in Make", "md_doc_2_run_gen.html#using-rungen-in-make", null ],
      [ "Known Issues & Caveats", "md_doc_2_run_gen.html#known-issues--caveats", null ]
    ] ],
    [ "Testing", "md_doc_2_testing.html", [
      [ "Organization", "md_doc_2_testing.html#organization", null ],
      [ "Debugging with LLDB", "md_doc_2_testing.html#debugging-with-lldb", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc_2_vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc_2_vulkan.html#compiling-halide-wvulkan-support", null ],
      [ "Vulkan Runtime Environment:", "md_doc_2_vulkan.html#vulkan-runtime-environment", [
        [ "Windows", "md_doc_2_vulkan.html#windows-3", null ],
        [ "Linux", "md_doc_2_vulkan.html#linux", null ],
        [ "Mac", "md_doc_2_vulkan.html#mac", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc_2_vulkan.html#testing-your-vulkan-environment", null ],
      [ "Targetting Vulkan", "md_doc_2_vulkan.html#targetting-vulkan", null ],
      [ "Useful Runtime Environment Variables", "md_doc_2_vulkan.html#useful-runtime-environment-variables", null ],
      [ "Debug Environment Variables", "md_doc_2_vulkan.html#debug-environment-variables", null ],
      [ "Current Status", "md_doc_2_vulkan.html#current-status", null ],
      [ "Caveats:", "md_doc_2_vulkan.html#caveats", null ],
      [ "Known TODO:", "md_doc_2_vulkan.html#known-todo", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc_2_web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc_2_web_assembly.html#additional-tooling-requirements", null ],
      [ "AOT Limitations", "md_doc_2_web_assembly.html#aot-limitations", null ],
      [ "JIT Limitations", "md_doc_2_web_assembly.html#jit-limitations", [
        [ "Using V8 as the interpreter", "md_doc_2_web_assembly.html#using-v8-as-the-interpreter", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc_2_web_assembly.html#to-use-halide-for-webassembly", [
        [ "Enabling wasm JIT", "md_doc_2_web_assembly.html#enabling-wasm-jit", null ],
        [ "Enabling wasm AOT", "md_doc_2_web_assembly.html#enabling-wasm-aot", null ]
      ] ],
      [ "Running benchmarks", "md_doc_2_web_assembly.html#running-benchmarks", null ],
      [ "Using Threads", "md_doc_2_web_assembly.html#using-threads", null ],
      [ "Known Limitations And Caveats", "md_doc_2_web_assembly.html#known-limitations-and-caveats", null ],
      [ "Known TODO:", "md_doc_2_web_assembly.html#known-todo-1", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc_2_web_g_p_u.html", [
      [ "Known limitations", "md_doc_2_web_g_p_u.html#known-limitations", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-with-webassembly-via-emscripten-hl_targetwasm-32-wasmrt-webgpu", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc_2_web_g_p_u.html#running-natively-hl_targethost-webgpu", null ],
      [ "Setting up Dawn", "md_doc_2_web_g_p_u.html#setting-up-dawn", null ],
      [ "Updating mini_webgpu.h", "md_doc_2_web_g_p_u.html#updating-mini_webgpuh", null ]
    ] ],
    [ "Topics", "topics.html", "topics" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Symbols", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#aaafd1baeff31b7d0293b95f041e0d116",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2af803729628adf4199f224c2a225038e9",
"_halide_runtime_8h.html#a02da52a04bf26d2636c9e70dd73b2fac",
"_halide_runtime_8h.html#ab3e13f5910a047d1908532367ce0b21f",
"_hexagon_optimize_8h.html#af6b52d96bb5a9b758cbaf557e35f4695",
"_i_r_operator_8h.html#a0c7bd26b46c10f2c3a6fc36da6a89518",
"_i_r_operator_8h.html#afc9c07e39289b14103ccd45ee31630a3",
"_offload_g_p_u_loops_8h_source.html",
"_type_8h.html#a34724aafceb69023d4041e3838714e81",
"block__allocator_8h_source.html",
"class_halide_1_1_default_cost_model.html#a8935988c2d55b2dca6366098d7436462",
"class_halide_1_1_func.html#aa348865f8302ff247d2ecd95b263ffb4",
"class_halide_1_1_generator_context.html#afbf8f747c6b7174f5bf3ea501c445a78",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#aa64e378d17dd33bc31dc6c4041ad958a",
"class_halide_1_1_internal_1_1_closure.html#abc09291ab8b4ee3cc0d3594e585e2093",
"class_halide_1_1_internal_1_1_code_gen___c.html#aa9d423572079a0db3dc4210d0daf54b9a75f381c061ee36f35692275a9df2a949",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#ab05994d9434b5f3cbd59fbe0b91682ce",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a66041a2278c8a881e7917238d0bed065",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ae34c68b59491d5f0d8f0da070981df26",
"class_halide_1_1_internal_1_1_code_gen___posix.html#af49b5db3e65a013ee095de5a43f62c59",
"class_halide_1_1_internal_1_1_elf_1_1_relocation.html#a695b7cdeaf14edb37ddd0a97d4a00650",
"class_halide_1_1_internal_1_1_func_schedule.html#a1f926eab0f3318f42c3f5dc308e9374d",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a90565d74e1e562ee5d8e9fca51fc15fa",
"class_halide_1_1_internal_1_1_generator_input___arithmetic.html#a3542859c0f7560c569f0dda738ed249d",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a9e9b4ad26d165941abdf4d67f25fccb8",
"class_halide_1_1_internal_1_1_generator_param_base.html#a9d859fd6df7ee2dfbafcd949d5dcc8d3",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a80badab90d2233c8ae3d83a68c277fc5",
"class_halide_1_1_internal_1_1_i_r_visitor.html#a0cba90cc11b924a157e1ac597e863487",
"class_halide_1_1_internal_1_1_scope.html#a3f0f48e938ee549b27d2ce4d80fb9eb8",
"class_halide_1_1_internal_1_1_stage_schedule.html",
"class_halide_1_1_names_interface.html",
"class_halide_1_1_parameter.html#acac5817d9ecff0217513e0214253b4de",
"class_halide_1_1_runtime_1_1_buffer.html#a2c5b03037f53363a00913ceef3bbf7aa",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a9702362aa8f398c7a6dc98fdda47a534",
"class_halide_1_1_runtime_1_1_internal_1_1_printer_base.html#a4714a18c7d67e02ca2748d3b21f9fc38",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#ac9187aefcae3551b4149909e30347956",
"classcmdline_1_1parser.html#a50b57c8179fe1b0dd8f5d2b8e8f3261b",
"functions_vars_y.html",
"md_doc_2_halide_c_make_package.html#bypass-cmake",
"mini__cl_8h.html#a425a9d07e249f25986903bc58f884c32",
"mini__cl_8h.html#ad0efadedc2f97d7f9c49d78a84cc865f",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaafdcdf3e8f367a3afd7a5a45d9a75740a",
"mini__d3d12_8h.html#a4b3b504f9841abc40fd900495620369c",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcaebd375433beb8ed9532ae34bd0620966",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335dac2b04ad61296678172aa3e633df323aa",
"mini__d3d12_8h.html#ae0b6f9fb54da98cbb1bb4318ead87dd0ad993b42271e8eb7348c6bc5b7395193d",
"mini__hexagon__dma_8h.html#ad70fa2815c3912018cf3a960dc74773d",
"mini__webgpu_8h.html#a19d5164965bfad0b124825ffe614b8dc",
"mini__webgpu_8h.html#a57a04e266142c3e6f3fd131481b2ec3fa2230d8cccf5ce66678d70a066ff25187",
"mini__webgpu_8h.html#a825c3d04e08b66e43cda3bdce9e77092ad2432cbe16af4da4126f2c61e49146d4",
"mini__webgpu_8h.html#ad3ce349696994e002651ebbe0e2ccb66",
"namespace_halide.html#a34f3541db2d08c4e3f18df546b8796ff",
"namespace_halide.html#abbad5ee20448455260670dec22c76a21",
"namespace_halide_1_1_internal.html#a25b077cb4a97dbf2fc64bb665826b512",
"namespace_halide_1_1_internal.html#a8c3c2f27463a8c2007fb94474a7d31e6",
"namespace_halide_1_1_internal.html#aee9e0b8e5376e2294d74ded8e7de9ef2a592a4f2501f4145b888a956d28448742",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a88969b742de298fa4e89c1b7e0cd9507",
"namespace_halide_1_1_runtime_1_1_internal_1_1_cuda.html#a2f191c22706ed27f2c64f0e1ab3d4ab9a844a30f1b1b9c5d4e7ec15a78d88fa76",
"namespacemembers_func_u.html",
"struct_d3_d12___c_o_m_m_a_n_d___q_u_e_u_e___d_e_s_c.html#ae36dc8bff7118cd077cdb9673392afe0",
"struct_d3_d12___s_a_m_p_l_e_r___d_e_s_c.html#a3836d53d632ac99aa21365994e0b3651",
"struct_halide_1_1_argument.html#a7447c40836134c47cb81bb47c9a59761",
"struct_halide_1_1_internal_1_1_acquire.html",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_cache.html",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_g_p_u_loop_info.html",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#ac451c4521ccf418a9e05a6d5d8b1e9e1",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_optional_rational.html#a3c6d356cedf281d86fb729ffcf554e4c",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a960bde177b17db5a32b7b3a702f69382",
"struct_halide_1_1_internal_1_1_box.html#a8fac5038393142589c9ce5f9a368b2d2",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974aef3949453b061d18a131004a3257db1d",
"struct_halide_1_1_internal_1_1_device_argument.html#ab58dfe9cea4c4314e37bc16b0e8a7354",
"struct_halide_1_1_internal_1_1_i_r_handle.html#a6fd71201f0c9587eec9b51ae87268fac",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_not_op.html#a4d1b8999c68921d260a86d582792d805",
"struct_halide_1_1_internal_1_1_inferred_argument.html#afdf7507421834713baa978435723aa95",
"struct_halide_1_1_internal_1_1_max.html#aba12da8ab371e2950c486503ad56dfd1",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dae0626222614bdee31951d84c64e5e9ff",
"struct_halide_1_1_internal_1_1_reduction_variable_1_1_compare.html#ad2c3d65f6d27b1d5d64f37d80038cde3",
"struct_halide_1_1_internal_1_1_schedule_features.html#afaa2fcf1d8a7396adbc4412180a63f36",
"struct_halide_1_1_internal_1_1_storage_dim.html#ab8e5040135437a8b4d902f9f5be9e935",
"struct_halide_1_1_py_torch_1_1_user_context.html#afd260f15b9a83c3bc0b469d93fc575df",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_block.html#a522c068d55763a36f87038082321ce2c",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_config.html",
"struct_halide_1_1_target.html#a9398276edd5784185e1a08f8a4dfc43fa067b0eb1f99b6ad38c8d8489458bd547",
"struct_halide_1_1_target.html#af2b0caf9e5badd6a8ebe22493752df20a5c630f5107a5a01870143d6dc042ea8c",
"struct_i_d3_d12_command_queue_vtbl.html#a877cb3a402c9575993c4c82b2ce3f16d",
"struct_i_d3_d12_graphics_command_list_vtbl.html#a4eeb7a6ae6f63559a8d67b84451e2342",
"struct_i_d_x_g_i_factory1_vtbl.html",
"struct_w_g_p_u_dawn_experimental_subgroup_limits.html#ae8e6dde4a1652f3c6dcc8813c4cbbf6d",
"struct_w_g_p_u_render_pass_storage_attachment.html#a545b391e73e3440633c04bca890ac11b",
"struct_w_g_p_u_texture_view_descriptor.html#a64624df5a09433bb183cb94525110e93",
"structst_dma_wrapper___frame_prop.html#a684ab57ba2bc5ac4649cbc12b4b5d179"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';