/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc__building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc__building_halide_with_c_make.html#autotoc_md1", [
        [ "Cross-platform", "md_doc__building_halide_with_c_make.html#autotoc_md2", null ],
        [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md3", null ],
        [ "macOS", "md_doc__building_halide_with_c_make.html#autotoc_md4", null ],
        [ "Ubuntu Linux", "md_doc__building_halide_with_c_make.html#autotoc_md5", null ],
        [ "Optional: Install Ninja", "md_doc__building_halide_with_c_make.html#autotoc_md6", null ]
      ] ],
      [ "Dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md7", [
        [ "Summary", "md_doc__building_halide_with_c_make.html#autotoc_md8", null ],
        [ "Installing dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md9", [
          [ "vcpkg", "md_doc__building_halide_with_c_make.html#autotoc_md10", null ],
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md11", null ],
          [ "Homebrew", "md_doc__building_halide_with_c_make.html#autotoc_md12", null ],
          [ "Ubuntu / Debian", "md_doc__building_halide_with_c_make.html#autotoc_md13", null ],
          [ "Python", "md_doc__building_halide_with_c_make.html#autotoc_md14", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc__building_halide_with_c_make.html#autotoc_md15", [
        [ "Basic build", "md_doc__building_halide_with_c_make.html#autotoc_md16", [
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md17", null ],
          [ "macOS and Linux", "md_doc__building_halide_with_c_make.html#autotoc_md18", null ]
        ] ],
        [ "CMake Presets", "md_doc__building_halide_with_c_make.html#autotoc_md19", [
          [ "Common presets", "md_doc__building_halide_with_c_make.html#autotoc_md20", null ],
          [ "Vcpkg presets", "md_doc__building_halide_with_c_make.html#autotoc_md21", null ],
          [ "Sanitizer presets", "md_doc__building_halide_with_c_make.html#autotoc_md22", null ]
        ] ],
        [ "Build options", "md_doc__building_halide_with_c_make.html#autotoc_md23", null ],
        [ "Installing", "md_doc__building_halide_with_c_make.html#autotoc_md24", null ]
      ] ],
      [ "Building Halide with pip", "md_doc__building_halide_with_c_make.html#autotoc_md25", [
        [ "Using ccache with pip builds", "md_doc__building_halide_with_c_make.html#autotoc_md26", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc__code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc__code_style_c_make.html#autotoc_md28", [
        [ "Prohibited commands list", "md_doc__code_style_c_make.html#autotoc_md29", null ],
        [ "Prohibited variables list", "md_doc__code_style_c_make.html#autotoc_md30", null ]
      ] ],
      [ "Adding tests", "md_doc__code_style_c_make.html#autotoc_md31", null ],
      [ "Adding apps", "md_doc__code_style_c_make.html#autotoc_md32", null ]
    ] ],
    [ "Fuzz testing", "md_doc__fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc__fuzz_testing.html#autotoc_md34", null ],
      [ "Using the fuzz-harnesses", "md_doc__fuzz_testing.html#autotoc_md35", null ],
      [ "Reproducing crashes", "md_doc__fuzz_testing.html#autotoc_md36", null ],
      [ "Adding new fuzz tests", "md_doc__fuzz_testing.html#autotoc_md37", null ],
      [ "Other useful materials", "md_doc__fuzz_testing.html#autotoc_md38", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc__halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc__halide_c_make_package.html#autotoc_md40", [
        [ "JIT mode", "md_doc__halide_c_make_package.html#autotoc_md41", null ],
        [ "AOT mode", "md_doc__halide_c_make_package.html#autotoc_md42", [
          [ "Autoschedulers", "md_doc__halide_c_make_package.html#autotoc_md43", null ],
          [ "RunGenMain", "md_doc__halide_c_make_package.html#autotoc_md44", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc__halide_c_make_package.html#autotoc_md45", [
        [ "Components", "md_doc__halide_c_make_package.html#autotoc_md46", null ],
        [ "Variables", "md_doc__halide_c_make_package.html#autotoc_md47", null ],
        [ "Imported targets", "md_doc__halide_c_make_package.html#autotoc_md48", null ],
        [ "Functions", "md_doc__halide_c_make_package.html#autotoc_md49", [
          [ "<tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md50", null ],
          [ "<tt>add_halide_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md51", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md52", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc__halide_c_make_package.html#autotoc_md53", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc__halide_c_make_package.html#autotoc_md54", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md55", null ],
        [ "Use a super-build", "md_doc__halide_c_make_package.html#autotoc_md56", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc__halide_c_make_package.html#autotoc_md57", null ],
        [ "Use an emulator or run on device", "md_doc__halide_c_make_package.html#autotoc_md58", null ],
        [ "Bypass CMake", "md_doc__halide_c_make_package.html#autotoc_md59", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc__hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc__hexagon.html#autotoc_md61", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc__hexagon.html#autotoc_md62", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc__hexagon.html#autotoc_md63", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc__hexagon.html#autotoc_md64", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc__python.html", [
      [ "Acquiring the Python bindings", "md_doc__python.html#autotoc_md66", null ],
      [ "Building the Python bindings", "md_doc__python.html#autotoc_md67", [
        [ "Using CMake directly", "md_doc__python.html#autotoc_md68", null ],
        [ "Using wheel infrastructure", "md_doc__python.html#autotoc_md69", null ]
      ] ],
      [ "Documentation and Examples", "md_doc__python.html#autotoc_md70", null ],
      [ "Differences from C++ API", "md_doc__python.html#autotoc_md71", null ],
      [ "Example of Simple Usage", "md_doc__python.html#autotoc_md72", null ],
      [ "Halide Generators In Python", "md_doc__python.html#autotoc_md73", [
        [ "Writing a Generator in Python", "md_doc__python.html#autotoc_md74", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc__python.html#autotoc_md75", null ],
          [ "hl.GeneratorParam", "md_doc__python.html#autotoc_md76", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc__python.html#autotoc_md77", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc__python.html#autotoc_md78", null ],
          [ "Names", "md_doc__python.html#autotoc_md79", null ],
          [ "generate() method", "md_doc__python.html#autotoc_md80", null ],
          [ "Types for Inputs and Outputs", "md_doc__python.html#autotoc_md81", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc__python.html#autotoc_md82", null ],
        [ "Using a Generator for AOT compilation", "md_doc__python.html#autotoc_md83", null ],
        [ "Calling Generator-Produced code from Python", "md_doc__python.html#autotoc_md84", null ],
        [ "Advanced Generator-Related Topics", "md_doc__python.html#autotoc_md85", [
          [ "Generator Aliases", "md_doc__python.html#autotoc_md86", null ],
          [ "Dynamic Inputs and Outputs", "md_doc__python.html#autotoc_md87", null ],
          [ "Calling a Generator Directly", "md_doc__python.html#autotoc_md88", null ],
          [ "The Lifecycle Of A Generator", "md_doc__python.html#autotoc_md89", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc__python.html#autotoc_md90", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc__python.html#autotoc_md91", null ],
      [ "License", "md_doc__python.html#autotoc_md92", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc__run_gen.html", [
      [ "Overview", "md_doc__run_gen.html#autotoc_md94", null ],
      [ "Benchmarking", "md_doc__run_gen.html#autotoc_md95", null ],
      [ "Measuring Memory Usage", "md_doc__run_gen.html#autotoc_md96", null ],
      [ "Using RunGen in Make", "md_doc__run_gen.html#autotoc_md97", null ],
      [ "Known Issues & Caveats", "md_doc__run_gen.html#autotoc_md98", null ]
    ] ],
    [ "Testing", "md_doc__testing.html", [
      [ "Organization", "md_doc__testing.html#autotoc_md100", null ],
      [ "Debugging with LLDB", "md_doc__testing.html#autotoc_md101", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc__vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc__vulkan.html#autotoc_md103", null ],
      [ "Vulkan Runtime Environment:", "md_doc__vulkan.html#autotoc_md104", [
        [ "Windows", "md_doc__vulkan.html#autotoc_md105", null ],
        [ "Linux", "md_doc__vulkan.html#autotoc_md106", null ],
        [ "Mac", "md_doc__vulkan.html#autotoc_md107", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc__vulkan.html#autotoc_md108", null ],
      [ "Targetting Vulkan", "md_doc__vulkan.html#autotoc_md109", null ],
      [ "Useful Runtime Environment Variables", "md_doc__vulkan.html#autotoc_md110", null ],
      [ "Debug Environment Variables", "md_doc__vulkan.html#autotoc_md111", null ],
      [ "Current Status", "md_doc__vulkan.html#autotoc_md112", null ],
      [ "Caveats:", "md_doc__vulkan.html#autotoc_md113", null ],
      [ "Known TODO:", "md_doc__vulkan.html#autotoc_md114", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc__web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc__web_assembly.html#autotoc_md116", null ],
      [ "AOT Limitations", "md_doc__web_assembly.html#autotoc_md117", null ],
      [ "JIT Limitations", "md_doc__web_assembly.html#autotoc_md118", [
        [ "Using V8 as the interpreter", "md_doc__web_assembly.html#autotoc_md119", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc__web_assembly.html#autotoc_md120", [
        [ "Enabling wasm JIT", "md_doc__web_assembly.html#autotoc_md121", null ],
        [ "Enabling wasm AOT", "md_doc__web_assembly.html#autotoc_md122", null ]
      ] ],
      [ "Running benchmarks", "md_doc__web_assembly.html#autotoc_md123", null ],
      [ "Using Threads", "md_doc__web_assembly.html#autotoc_md124", null ],
      [ "Known Limitations And Caveats", "md_doc__web_assembly.html#autotoc_md125", null ],
      [ "Known TODO:", "md_doc__web_assembly.html#autotoc_md126", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc__web_g_p_u.html", [
      [ "Known limitations", "md_doc__web_g_p_u.html#autotoc_md128", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md129", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md130", null ],
      [ "Setting up Dawn", "md_doc__web_g_p_u.html#autotoc_md131", null ],
      [ "Updating mini_webgpu.h", "md_doc__web_g_p_u.html#autotoc_md132", null ]
    ] ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#a8e2154ce76c37412e7d74c0c7fe5fecb",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2ae8b4b40ec3622e371789b790caabc083",
"_halide_runtime_8h.html",
"_halide_runtime_8h.html#ab199bb9f42e5a36069af2e8b08994eef",
"_hexagon_optimize_8h.html#ad61e99863aa9fd2833e535440b632093",
"_i_r_operator_8h.html#a082d3bda0d60128ae127d0879e7e38c9",
"_i_r_operator_8h.html#af7df709582bdb9d7844efa9cd6b69625",
"_monotonic_8h.html#aecd75538cec762a0ec020c81708260b6",
"_type_8h.html#a0fbca831439bde92087c2821e1a76df7",
"android__ioctl_8h.html#aefe531e01b900d7ec9446d8a72060870",
"class_halide_1_1_default_cost_model.html#a7e1e8276960aefbacf55c13990372195",
"class_halide_1_1_func.html#a9d619f2d0111ea5bf640781d1324d050",
"class_halide_1_1_generator_context.html#a697a82ac8ecc83494e7cdbd31ac78c44",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a5c608676745faf2ccee7645f81473b49",
"class_halide_1_1_internal_1_1_closure.html#aaf0bb1168612d9b2af5769112f9d4800",
"class_halide_1_1_internal_1_1_code_gen___c.html#a9f70fa702a75f4274bcfde028742bb94",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aa0835166d9c7648edcfbbc0c30b209a7",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a59e33f468f9c83e0a845621d42489450",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ad6be7d801b1c3ae8899b6afc4c233ff1",
"class_halide_1_1_internal_1_1_code_gen___posix.html#ad3e6d5d63ab4841ec3d4903c7e7a4c34",
"class_halide_1_1_internal_1_1_elf_1_1_object.html#ad2d5244018a896e7c4603ae6d5bf5d63",
"class_halide_1_1_internal_1_1_elf_1_1iterator__range.html#a8c3600237f704a40ae0f21c26728a8fc",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a3d8b05ed049447f7e2980bf7e0a05b54",
"class_halide_1_1_internal_1_1_generator_factory_provider.html#a1a61aba8ccd44a3da43d54bec51ae65a",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a099381f3dd8d90883c69864803eba7dc",
"class_halide_1_1_internal_1_1_generator_param_base.html#a2c6329e63769c3148b2467d1681abf36",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a47090722eadcd086f103df327ac614bd",
"class_halide_1_1_internal_1_1_i_r_printer.html#add7a42010cf31ae07f036a3380b64e82",
"class_halide_1_1_internal_1_1_register_generator.html#ac39038d187e32e7e46e77509ebfd2c87",
"class_halide_1_1_internal_1_1_small_stack.html#a4c07bb158cf05f2e1c5a540996b39aa8",
"class_halide_1_1_module.html#aaa65efdad0e77774fe352cc34f5b97bd",
"class_halide_1_1_parameter.html#aab7b52e612c9980dc1eb7dcb1a3f6372",
"class_halide_1_1_runtime_1_1_buffer.html#a0befbe03735d82b6a18ec9113ec7c3cb",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a08a585d64b4e299bacff6ff2f150733c",
"class_halide_1_1_runtime_1_1_internal_1_1_pointer_table.html#ae34577a27cca7cf912c75b25c49b4d91",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#a5948a9bc3b84ee892d63e4bea69e188a",
"class_perfect_hash_map.html#a5043b05f4ce7960f93772f35b12b5ae8",
"functions_vars.html",
"md_doc__building_halide_with_c_make.html#autotoc_md4",
"mini__cl_8h.html#a34e095869f2fb0a057302dada675827b",
"mini__cl_8h.html#ac17e3aded080b8eac8f6de277c0ee946",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaaaa3765a010760b4a04369ec02e0c8a2a",
"mini__d3d12_8h.html#a42d3fc0cfc9f77e2d79cd0823849fa80",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcac118e7261cff00e44a04ce82ac498541",
"mini__d3d12_8h.html#aa07a1f2688ae36addd83202223eff534",
"mini__d3d12_8h.html#ad6a344eb6e138554b412331390602e30aacfd96b925ef2614060f471f8862a30a",
"mini__hexagon__dma_8h.html#a08e2c9be9853adcb4ec95c535f75ff4f",
"mini__webgpu_8h.html#a0ec65eac190d66db5e90cfcee73f97cd",
"mini__webgpu_8h.html#a4e9c9ccf9e7ce371e95a586b0f81c85dab2b14072069cfb8e244933768b6014bd",
"mini__webgpu_8h.html#a7fa2c2627783fe742a84ebb6c3618726a013c6aa8a00ca68bf7a8f53159594003",
"mini__webgpu_8h.html#ac9935810c91e2fc75f1102c486655a22",
"namespace_halide.html#a1b6d9d01ef649f4702ff8dca3b6871cf",
"namespace_halide.html#aa373ab31181627dc3ed16ac676e561a8",
"namespace_halide_1_1_internal.html#a16182ff30077d1ecfc92f992ff2faccc",
"namespace_halide_1_1_internal.html#a7eae0313e2330e7c9003fc623ae4fe3b",
"namespace_halide_1_1_internal.html#ae44671b17b544e30b42100c14a337704",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a5d77510464f34ea78223de56f8742734",
"namespace_halide_1_1_runtime_1_1_internal.html#ae948f665a6e90b58feb32e8e8fbc8383",
"namespacecmdline_1_1detail.html#a9e3c4f02792dba7836cb5d933bf8665f",
"struct__qurt__thread__attr.html",
"struct_d3_d12___r_o_o_t___d_e_s_c_r_i_p_t_o_r.html#a9d7d63e3d74cbd441458823d46d0e874",
"struct_d_x_g_i___a_d_a_p_t_e_r___d_e_s_c.html#a1f9fed75f7e5c770bf965bd830d4fd00",
"struct_halide_1_1_extern_signature.html#ae6777bb2a89a929009acd48441282dbf",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#a19bfed67131ee9d4efdb1de28b36058e",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#a24a726cafb3900a86c97d07ad7053dcc",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#aa15edb58a0a4b438411fdca95f78a6f0",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_mem_traits_3_01_global_mem_01_4.html#a238fe2451357c382927ecd10a55b1bb0",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a5115aff81fe4271c150fd1400544a3b7",
"struct_halide_1_1_internal_1_1_block.html",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974ac8bd6941ba13454eb1b922d54b9dc095",
"struct_halide_1_1_internal_1_1_constant_interval.html#add7cf5acb8aaadae56474ba3ef1c6816",
"struct_halide_1_1_internal_1_1_g_e.html",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_matcher_state.html#a0f804a1871a23b81f99f4709dc07e9d9",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_wild_const_u_int_1_1pattern__tag.html",
"struct_halide_1_1_internal_1_1_lambda_mutator.html#a2c51e83cfa7d2581226c38fe1177215a",
"struct_halide_1_1_internal_1_1_lowered_func.html#aef641f5f2b43ea2b20bdca7f7815105b",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dadc33066c3993e0d50896e533fd692ce0",
"struct_halide_1_1_internal_1_1_reduction_variable.html#a47155e337ea2ef6dd11a72d8ccdeca65",
"struct_halide_1_1_internal_1_1_schedule_features.html#af673a05ffd4f2cdf23b840554de25530",
"struct_halide_1_1_internal_1_1_storage_dim.html#a041a7ae1ebaaec95836ddeaff514f5ff",
"struct_halide_1_1_py_torch_1_1_user_context.html#a121354047ecc6cc283537882036377ff",
"struct_halide_1_1_runtime_1_1_internal_1_1_memory_arena_1_1_config.html#adae92ade9b385f09fec05cc961481ffe",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_dispatch_data.html#a668766781eebea2670493905adfb1809",
"struct_halide_1_1_target.html#a9398276edd5784185e1a08f8a4dfc43f",
"struct_halide_1_1_target.html#af2b0caf9e5badd6a8ebe22493752df20",
"struct_halide_1_1float16__t.html#ac63daca38700f7e445b490c624b05db3",
"struct_i_d3_d12_device_vtbl.html#af642e703b878326fba3163dd0777adf3",
"struct_i_d3_d12_resource_vtbl.html#a600445802a930322ef10661324b72898",
"struct_w_g_p_u_compilation_message.html#ab8dc8ce860e8da1105a8cb8c2cdd7028",
"struct_w_g_p_u_programmable_stage_descriptor.html#a6ff2aedcb369268026a9ba85f21d754d",
"struct_w_g_p_u_surface_descriptor.html#aaeb7a3c26e91ed0850b6ab72d762debc",
"structhalide__pseudostack__slot__t.html#ac7e858e37f27eef95c3d7a6e15e60209",
"vulkan__memory_8h.html#a27049beec22084662a83b0d6a0b2e2cd"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';