/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Halide", "index.html", [
    [ "Building Halide with CMake", "md_doc__building_halide_with_c_make.html", [
      [ "Installing CMake", "md_doc__building_halide_with_c_make.html#autotoc_md1", [
        [ "Cross-platform", "md_doc__building_halide_with_c_make.html#autotoc_md2", null ],
        [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md3", null ],
        [ "macOS", "md_doc__building_halide_with_c_make.html#autotoc_md4", null ],
        [ "Ubuntu Linux", "md_doc__building_halide_with_c_make.html#autotoc_md5", null ],
        [ "Optional: Install Ninja", "md_doc__building_halide_with_c_make.html#autotoc_md6", null ]
      ] ],
      [ "Dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md7", [
        [ "Summary", "md_doc__building_halide_with_c_make.html#autotoc_md8", null ],
        [ "Installing dependencies", "md_doc__building_halide_with_c_make.html#autotoc_md9", [
          [ "vcpkg", "md_doc__building_halide_with_c_make.html#autotoc_md10", null ],
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md11", null ],
          [ "Homebrew", "md_doc__building_halide_with_c_make.html#autotoc_md12", null ],
          [ "Ubuntu / Debian", "md_doc__building_halide_with_c_make.html#autotoc_md13", null ],
          [ "Python", "md_doc__building_halide_with_c_make.html#autotoc_md14", null ]
        ] ]
      ] ],
      [ "Building Halide", "md_doc__building_halide_with_c_make.html#autotoc_md15", [
        [ "Basic build", "md_doc__building_halide_with_c_make.html#autotoc_md16", [
          [ "Windows", "md_doc__building_halide_with_c_make.html#autotoc_md17", null ],
          [ "macOS and Linux", "md_doc__building_halide_with_c_make.html#autotoc_md18", null ]
        ] ],
        [ "CMake Presets", "md_doc__building_halide_with_c_make.html#autotoc_md19", [
          [ "Common presets", "md_doc__building_halide_with_c_make.html#autotoc_md20", null ],
          [ "Vcpkg presets", "md_doc__building_halide_with_c_make.html#autotoc_md21", null ],
          [ "Sanitizer presets", "md_doc__building_halide_with_c_make.html#autotoc_md22", null ]
        ] ],
        [ "Build options", "md_doc__building_halide_with_c_make.html#autotoc_md23", null ],
        [ "Installing", "md_doc__building_halide_with_c_make.html#autotoc_md24", null ]
      ] ],
      [ "Building Halide with pip", "md_doc__building_halide_with_c_make.html#autotoc_md25", [
        [ "Using ccache with pip builds", "md_doc__building_halide_with_c_make.html#autotoc_md26", null ]
      ] ]
    ] ],
    [ "Contributing CMake code to Halide", "md_doc__code_style_c_make.html", [
      [ "General guidelines and best practices", "md_doc__code_style_c_make.html#autotoc_md28", [
        [ "Prohibited commands list", "md_doc__code_style_c_make.html#autotoc_md29", null ],
        [ "Prohibited variables list", "md_doc__code_style_c_make.html#autotoc_md30", null ]
      ] ],
      [ "Adding tests", "md_doc__code_style_c_make.html#autotoc_md31", null ],
      [ "Adding apps", "md_doc__code_style_c_make.html#autotoc_md32", null ]
    ] ],
    [ "Fuzz testing", "md_doc__fuzz_testing.html", [
      [ "Building fuzz tests", "md_doc__fuzz_testing.html#autotoc_md34", null ],
      [ "Using the fuzz-harnesses", "md_doc__fuzz_testing.html#autotoc_md35", null ],
      [ "Reproducing crashes", "md_doc__fuzz_testing.html#autotoc_md36", null ],
      [ "Adding new fuzz tests", "md_doc__fuzz_testing.html#autotoc_md37", null ],
      [ "Other useful materials", "md_doc__fuzz_testing.html#autotoc_md38", null ]
    ] ],
    [ "Using Halide from your CMake build", "md_doc__halide_c_make_package.html", [
      [ "A basic CMake project", "md_doc__halide_c_make_package.html#autotoc_md40", [
        [ "JIT mode", "md_doc__halide_c_make_package.html#autotoc_md41", null ],
        [ "AOT mode", "md_doc__halide_c_make_package.html#autotoc_md42", [
          [ "Autoschedulers", "md_doc__halide_c_make_package.html#autotoc_md43", null ],
          [ "RunGenMain", "md_doc__halide_c_make_package.html#autotoc_md44", null ]
        ] ]
      ] ],
      [ "Halide package documentation", "md_doc__halide_c_make_package.html#autotoc_md45", [
        [ "Components", "md_doc__halide_c_make_package.html#autotoc_md46", null ],
        [ "Variables", "md_doc__halide_c_make_package.html#autotoc_md47", null ],
        [ "Imported targets", "md_doc__halide_c_make_package.html#autotoc_md48", null ],
        [ "Functions", "md_doc__halide_c_make_package.html#autotoc_md49", [
          [ "<tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md50", null ],
          [ "<tt>add_halide_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md51", null ],
          [ "<tt>add_halide_python_extension_library</tt>", "md_doc__halide_c_make_package.html#autotoc_md52", null ],
          [ "<tt>add_halide_runtime</tt>", "md_doc__halide_c_make_package.html#autotoc_md53", null ]
        ] ]
      ] ],
      [ "Cross compiling", "md_doc__halide_c_make_package.html#autotoc_md54", [
        [ "Use <tt>add_halide_generator</tt>", "md_doc__halide_c_make_package.html#autotoc_md55", null ],
        [ "Use a super-build", "md_doc__halide_c_make_package.html#autotoc_md56", null ],
        [ "Use <tt>ExternalProject</tt> directly", "md_doc__halide_c_make_package.html#autotoc_md57", null ],
        [ "Use an emulator or run on device", "md_doc__halide_c_make_package.html#autotoc_md58", null ],
        [ "Bypass CMake", "md_doc__halide_c_make_package.html#autotoc_md59", null ]
      ] ]
    ] ],
    [ "Halide for Hexagon HVX", "md_doc__hexagon.html", [
      [ "1. Obtain and build trunk LLVM and Clang", "md_doc__hexagon.html#autotoc_md61", null ],
      [ "2. Download and install the Hexagon SDK and Hexagon Tools", "md_doc__hexagon.html#autotoc_md62", null ],
      [ "3. Build and run an example for Hexagon HVX", "md_doc__hexagon.html#autotoc_md63", null ],
      [ "To build and run the blur example in Halide/apps/blur on Android:", "md_doc__hexagon.html#autotoc_md64", null ]
    ] ],
    [ "Halide Bindings for Python", "md_doc__python.html", [
      [ "Acquiring the Python bindings", "md_doc__python.html#autotoc_md66", null ],
      [ "Building the Python bindings", "md_doc__python.html#autotoc_md67", [
        [ "Using CMake directly", "md_doc__python.html#autotoc_md68", null ],
        [ "Using wheel infrastructure", "md_doc__python.html#autotoc_md69", null ]
      ] ],
      [ "Documentation and Examples", "md_doc__python.html#autotoc_md70", null ],
      [ "Differences from C++ API", "md_doc__python.html#autotoc_md71", null ],
      [ "Example of Simple Usage", "md_doc__python.html#autotoc_md72", null ],
      [ "Halide Generators In Python", "md_doc__python.html#autotoc_md73", [
        [ "Writing a Generator in Python", "md_doc__python.html#autotoc_md74", [
          [ "<tt>hl.generator(\"name\")</tt>", "md_doc__python.html#autotoc_md75", null ],
          [ "hl.GeneratorParam", "md_doc__python.html#autotoc_md76", null ],
          [ "hl.InputBuffer, hl.InputScalar", "md_doc__python.html#autotoc_md77", null ],
          [ "hl.OutputBuffer, hl.OutputScalar", "md_doc__python.html#autotoc_md78", null ],
          [ "Names", "md_doc__python.html#autotoc_md79", null ],
          [ "generate() method", "md_doc__python.html#autotoc_md80", null ],
          [ "Types for Inputs and Outputs", "md_doc__python.html#autotoc_md81", null ]
        ] ],
        [ "Using a Generator for JIT compilation", "md_doc__python.html#autotoc_md82", null ],
        [ "Using a Generator for AOT compilation", "md_doc__python.html#autotoc_md83", null ],
        [ "Calling Generator-Produced code from Python", "md_doc__python.html#autotoc_md84", null ],
        [ "Advanced Generator-Related Topics", "md_doc__python.html#autotoc_md85", [
          [ "Generator Aliases", "md_doc__python.html#autotoc_md86", null ],
          [ "Dynamic Inputs and Outputs", "md_doc__python.html#autotoc_md87", null ],
          [ "Calling a Generator Directly", "md_doc__python.html#autotoc_md88", null ],
          [ "The Lifecycle Of A Generator", "md_doc__python.html#autotoc_md89", null ],
          [ "Notable Differences Between C++ and Python Generators", "md_doc__python.html#autotoc_md90", null ]
        ] ]
      ] ],
      [ "Keeping Up To Date", "md_doc__python.html#autotoc_md91", null ],
      [ "License", "md_doc__python.html#autotoc_md92", null ]
    ] ],
    [ "Running and Benchmarking Halide Generators", "md_doc__run_gen.html", [
      [ "Overview", "md_doc__run_gen.html#autotoc_md94", null ],
      [ "Benchmarking", "md_doc__run_gen.html#autotoc_md95", null ],
      [ "Measuring Memory Usage", "md_doc__run_gen.html#autotoc_md96", null ],
      [ "Using RunGen in Make", "md_doc__run_gen.html#autotoc_md97", null ],
      [ "Known Issues & Caveats", "md_doc__run_gen.html#autotoc_md98", null ]
    ] ],
    [ "Testing", "md_doc__testing.html", [
      [ "Organization", "md_doc__testing.html#autotoc_md100", null ],
      [ "Debugging with LLDB", "md_doc__testing.html#autotoc_md101", null ]
    ] ],
    [ "Vulkan Support for Halide", "md_doc__vulkan.html", [
      [ "Compiling Halide w/Vulkan Support", "md_doc__vulkan.html#autotoc_md103", null ],
      [ "Vulkan Runtime Environment:", "md_doc__vulkan.html#autotoc_md104", [
        [ "Windows", "md_doc__vulkan.html#autotoc_md105", null ],
        [ "Linux", "md_doc__vulkan.html#autotoc_md106", null ],
        [ "Mac", "md_doc__vulkan.html#autotoc_md107", null ]
      ] ],
      [ "Testing Your Vulkan Environment", "md_doc__vulkan.html#autotoc_md108", null ],
      [ "Targetting Vulkan", "md_doc__vulkan.html#autotoc_md109", null ],
      [ "Useful Runtime Environment Variables", "md_doc__vulkan.html#autotoc_md110", null ],
      [ "Debug Environment Variables", "md_doc__vulkan.html#autotoc_md111", null ],
      [ "Current Status", "md_doc__vulkan.html#autotoc_md112", null ],
      [ "Caveats:", "md_doc__vulkan.html#autotoc_md113", null ],
      [ "Known TODO:", "md_doc__vulkan.html#autotoc_md114", null ]
    ] ],
    [ "WebAssembly Support for Halide", "md_doc__web_assembly.html", [
      [ "Additional Tooling Requirements:", "md_doc__web_assembly.html#autotoc_md116", null ],
      [ "AOT Limitations", "md_doc__web_assembly.html#autotoc_md117", null ],
      [ "JIT Limitations", "md_doc__web_assembly.html#autotoc_md118", [
        [ "Using V8 as the interpreter", "md_doc__web_assembly.html#autotoc_md119", null ]
      ] ],
      [ "To Use Halide For WebAssembly:", "md_doc__web_assembly.html#autotoc_md120", [
        [ "Enabling wasm JIT", "md_doc__web_assembly.html#autotoc_md121", null ],
        [ "Enabling wasm AOT", "md_doc__web_assembly.html#autotoc_md122", null ]
      ] ],
      [ "Running benchmarks", "md_doc__web_assembly.html#autotoc_md123", null ],
      [ "Using Threads", "md_doc__web_assembly.html#autotoc_md124", null ],
      [ "Known Limitations And Caveats", "md_doc__web_assembly.html#autotoc_md125", null ],
      [ "Known TODO:", "md_doc__web_assembly.html#autotoc_md126", null ]
    ] ],
    [ "WebGPU support for Halide", "md_doc__web_g_p_u.html", [
      [ "Known limitations", "md_doc__web_g_p_u.html#autotoc_md128", null ],
      [ "Running with WebAssembly via Emscripten: <tt>HL_TARGET=wasm-32-wasmrt-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md129", null ],
      [ "Running natively: <tt>HL_TARGET=host-webgpu</tt>", "md_doc__web_g_p_u.html#autotoc_md130", null ],
      [ "Setting up Dawn", "md_doc__web_g_p_u.html#autotoc_md131", null ],
      [ "Updating mini_webgpu.h", "md_doc__web_g_p_u.html#autotoc_md132", null ]
    ] ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", "namespacemembers_func" ],
        [ "Variables", "namespacemembers_vars.html", null ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", "functions_eval" ],
        [ "Related Functions", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", "globals_type" ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ],
    [ "Examples", "examples.html", "examples" ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_s_log_8h.html",
"_concise_casts_8h.html#a8e2154ce76c37412e7d74c0c7fe5fecb",
"_expr_8h.html#aee9e0b8e5376e2294d74ded8e7de9ef2ae8b4b40ec3622e371789b790caabc083",
"_halide_runtime_8h.html",
"_halide_runtime_8h.html#ab199bb9f42e5a36069af2e8b08994eef",
"_hexagon_optimize_8h.html#ad61e99863aa9fd2833e535440b632093",
"_i_r_operator_8h.html#a09688fdcdef640b559405579e0048ded",
"_i_r_operator_8h.html#af9105ae9f0995f450825e522170f5d1e",
"_object_instance_registry_8h.html",
"_type_8h.html#a1921c164d599215c142b849092728f58",
"android__ioctl_8h.html#afb20e2f91557abf9104192c2d3896815",
"class_halide_1_1_default_cost_model.html#a842c7b068634e5f3cee34dcabc52ce42",
"class_halide_1_1_func.html#aa17f5091968639d630d29f640aff21dd",
"class_halide_1_1_generator_context.html#ad725d02ec831b39a4b63174bece205de",
"class_halide_1_1_internal_1_1_autoscheduler_1_1_expr_branching.html#a9295d0cdb548a8932058768f1d60ee3c",
"class_halide_1_1_internal_1_1_closure.html#ab9f584b5e5ba025878bc8b7987e4df69",
"class_halide_1_1_internal_1_1_code_gen___c.html#aa80d583912c4f167f6a520d4bc922143",
"class_halide_1_1_internal_1_1_code_gen___g_p_u___c.html#aaf31ae3fe2a9a22d2afa93583ad4ac07",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#a60a31951805271d85f036762be8ada94",
"class_halide_1_1_internal_1_1_code_gen___l_l_v_m.html#ae1b36b542f6faf3467ef94ec4b75252a",
"class_halide_1_1_internal_1_1_code_gen___posix.html#ae787f737dd34906d18ad739f67d66d23",
"class_halide_1_1_internal_1_1_elf_1_1_relocation.html",
"class_halide_1_1_internal_1_1_func_schedule.html",
"class_halide_1_1_internal_1_1_g_i_o_base.html#a7b6460c4d4877176a457974af48b6385",
"class_halide_1_1_internal_1_1_generator_input___arithmetic.html",
"class_halide_1_1_internal_1_1_generator_output___buffer.html#a7f47fbb9fc1e1d065bd03826bb622c63",
"class_halide_1_1_internal_1_1_generator_param_base.html#a7acb0df059266da11dc217b370097f49",
"class_halide_1_1_internal_1_1_i_r_mutator.html#a72b7e92a99eb6102b6a8314553c5611e",
"class_halide_1_1_internal_1_1_i_r_printer.html#afd54c82f06a521302a4acb30faa06cd0",
"class_halide_1_1_internal_1_1_scope.html#a0fe3cedb277751dfe09b62ca535a25b5",
"class_halide_1_1_internal_1_1_small_stack_3_01void_01_4.html#a02e6c475e518785524a4a4967a52ed68",
"class_halide_1_1_module.html#ae800344e6953a9e4643d0f7c59fb429e",
"class_halide_1_1_parameter.html#ac6d1cf0aa6596a2612d20ff37575be13",
"class_halide_1_1_runtime_1_1_buffer.html#a2896c0fece6ded34826d5768e2c65a5f",
"class_halide_1_1_runtime_1_1_internal_1_1_block_allocator.html#a678448cecb2d53356f9e42f8ceb4f4f8",
"class_halide_1_1_runtime_1_1_internal_1_1_printer_base.html#a2cda49d4fa179a28bcfd712efa8cdd91",
"class_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_memory_allocator.html#aa5fbc2be7b8314f8235b4cd0502618ff",
"classcmdline_1_1parser.html#a0267b636f34a788f57d5eeffcc5daf44",
"functions_vars_s.html",
"md_doc__halide_c_make_package.html#autotoc_md40",
"mini__cl_8h.html#a3e6a2a46b80f3608bcecebad6f38f7b7",
"mini__cl_8h.html#acb9debdf03548adc064edd0effd84ab4",
"mini__cuda_8h.html#af19313e44c60ca273901b267a591bffaade1894d9ea8398228c5850183ddc5e14",
"mini__d3d12_8h.html#a4b3b504f9841abc40fd900495620369c",
"mini__d3d12_8h.html#a6a9cbc7eff00c7ec769e4e6c3b2cb3bcaeaf5a99e69c70d6eae1db27ea1a0d08f",
"mini__d3d12_8h.html#aa17aa580f92e79f3f9394e558657335da6fb3972f7e297e58271d6d96bebe76f4",
"mini__d3d12_8h.html#add192197d3328c2874fef78c096507e4",
"mini__hexagon__dma_8h.html#aa06e6f42f5a1ea6fed90f756b659c9da",
"mini__webgpu_8h.html#a12f7feb6ca5109a598534f35243580c5a8a3c8a78983a71b0480dfe0ceb144a21",
"mini__webgpu_8h.html#a57a04e266142c3e6f3fd131481b2ec3f",
"mini__webgpu_8h.html#a80806f0d62fb1202eb0daa289e177dfc",
"mini__webgpu_8h.html#ad217e4262d5b9b79d4ce151f95b0c9ae",
"namespace_halide.html#a253aa716701aa1579cffd37c5fec9d70",
"namespace_halide.html#ab62c2d20ef1a0a924c80d8f7348341b1",
"namespace_halide_1_1_internal.html#a1fe4e051947dc094f3136a7b1e69a1e1",
"namespace_halide_1_1_internal.html#a866d7f181b8a337d445a1df28de18384",
"namespace_halide_1_1_internal.html#aee9e0b8e5376e2294d74ded8e7de9ef2a17335c02c86e7a0a2b46540df1e45eb5",
"namespace_halide_1_1_internal_1_1_i_r_matcher.html#a7689614d4251361497fe8b3d90943581",
"namespace_halide_1_1_runtime_1_1_internal_1_1_cuda.html#a2f191c22706ed27f2c64f0e1ab3d4ab9a1e768134f6fa6134826e8122dc2ac35b",
"namespacemembers_func_f.html",
"struct_d3_d12___b_u_f_f_e_r___u_a_v.html#a3714ab7a7cafa8d5b2134dc3d7622d06",
"struct_d3_d12___r_o_o_t___p_a_r_a_m_e_t_e_r1.html#ae2b2c1a60a875021264816c82d188198",
"struct_halide_1_1_argument.html",
"struct_halide_1_1_implicit_var.html#af9d1805898f050dd4f9c4871a3e33849",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_bound_contents.html#ac1bb856704cbdf7a99e38c25a6e59a6c",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_function_d_a_g_1_1_node_1_1_stage.html#a91bd5377c4c442f7d81688c0cc8ad1d7",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_loop_nest.html#ab9a1e0d893e5f721cb35e6bc347d74ae",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_optional_rational.html#a0230f7968d6755797c16a3ed1e85f70b",
"struct_halide_1_1_internal_1_1_autoscheduler_1_1_state.html#a80c18d972b84c19b55e7925b890dfc8f",
"struct_halide_1_1_internal_1_1_box.html#a1fab4f1a64ec075c717bb0d067b76327",
"struct_halide_1_1_internal_1_1_call.html#a3643a3e5cf73435e07215fca17949974ae8e007db3e91dbead585c960fceb95f7",
"struct_halide_1_1_internal_1_1_cost.html#ac2172cde8fada4db205aa089bac9b837",
"struct_halide_1_1_internal_1_1_i_r_deep_compare.html",
"struct_halide_1_1_internal_1_1_i_r_matcher_1_1_negate_op.html#a6a12a62c818d6bf7f38c4f21631e86c0",
"struct_halide_1_1_internal_1_1_if_then_else.html#afd7147872ed18ea25fbe121ce98a2230",
"struct_halide_1_1_internal_1_1_lowered_func.html#a9fe31f7c307b145fef4af0ec397a9014",
"struct_halide_1_1_internal_1_1_pipeline_features.html#a24dd570f5cbc57c750aca4c0d82f418dad6a38b57a0036d6aee4d17caae7dab6d",
"struct_halide_1_1_internal_1_1_reduction_domain_1_1_compare.html",
"struct_halide_1_1_internal_1_1_schedule_features.html#af255a9a034760ae4a32e5158a4f45f1b",
"struct_halide_1_1_internal_1_1_stmt_node.html#a52e238411f4a6db547106ca8e80ca722",
"struct_halide_1_1_pipeline_1_1_realization_arg.html#ad5147b0548564ea793ba101967299d85",
"struct_halide_1_1_runtime_1_1_internal_1_1_linked_list_1_1_entry_type.html#abaa3031f3e6d2228659918cba49f2d76",
"struct_halide_1_1_runtime_1_1_internal_1_1_vulkan_1_1_vulkan_compiled_shader_module.html#a5ccab4e8e7eb66f9072959d5234c685c",
"struct_halide_1_1_target.html#a8394ab88fb236f51ea92c6d7e44f87af",
"struct_halide_1_1_target.html#af17585cfd5ec92952fd361117d89d4b1a25390aa4e88778d47cddac690dbd23ea",
"struct_halide_1_1float16__t.html#aaaec609013996346b8ec939427a30eb8",
"struct_i_d3_d12_device_vtbl.html#adf0983481c98eaca37d1b1f88a94a7e8",
"struct_i_d3_d12_resource_vtbl.html#a20afd6fac5c67a02cdfaa30621300730",
"struct_w_g_p_u_compilation_info.html#a829a2b6d96756fb2bd8c87567be38b3f",
"struct_w_g_p_u_primitive_state.html",
"struct_w_g_p_u_storage_texture_binding_layout.html#a051c1985f739a56a24c935d8aa43d497",
"structhalide__profiler__state.html#a468bbaf228545bd37aa32632d46b5ccd",
"vulkan__interface_8h.html#ae6684c6c6ddec2423e75562ea075fc92"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';